<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Adm_News_Management extends CI_Controller {

 public function __construct() {
  parent::__construct();
  $mytype = $this->session->userdata("mytype");
  if ($mytype != 'a' && $mytype != 'o') {
   redirect(base_url(), "refresh");
 }
 date_default_timezone_set("Asia/Dhaka");
}

public function index() {
  $data = array();
  $data['title'] = "Famous News 24";
  $data['keywords'] = "";
  $data['description'] = "";
  $data['menu'] = "news";
  $this->load->library("form_validation");
  $data["allMenu"] = $this->am->View_Data("menu", "*", "", array("name", "asc"), "");
  $data['content'] = $this->load->view("admin/news-new", $data, TRUE);
  $this->load->view('admin/master', $data);
}

public function insert() {
  $data = array();
  $data['title'] = "Famous News 24";
  $data['keywords'] = "";
  $data['description'] = "";
  $data['menu'] = "news";
  $this->load->library("form_validation");
  $this->form_validation->set_rules("title", "Title", "required|trim");
  $this->form_validation->set_rules("descr", "Description", "required|trim");

  if ($this->form_validation->run() == FALSE) {
   $data["allMenu"] = $this->am->View_Data("menu", "*", "", array("name", "asc"), "");
   $data['content'] = $this->load->view("admin/news-new", $data, TRUE);
   $this->load->view('admin/master', $data);
 } else {



   $sdata = array(
     "title" => filter($this->input->post("title")),
     "color" => filter($this->input->post("color")),
     "news_source" => filter($this->input->post("news_source")),
     "shoulder_top" => filter($this->input->post("shoulder_top")),
     "shoulder_bottom" => filter($this->input->post("shoulder_bottom")),             
     "head_position" => filter($this->input->post("head_position")),
     "menu_position" => filter($this->input->post("menu_position")),
     "video" => filter($this->input->post("video")),
     "headline" => filter($this->input->post("headline")),
     "breaking" => filter($this->input->post("breaking")),
     "datetime" => date("Y-m-d H:i:s"),
     "published" => filter($this->input->post("published")),
     "img_url" => filter($this->input->post("img_url"))
     );

   $menuid = filter($this->input->post("menuid"));
   $submenuid = filter($this->input->post("submenuid"));
   if($menuid == 55){
    $sdata['menuid'] = $submenuid;
  }
  else{
   $sdata['menuid'] = $menuid;
 }

 if ($this->am->Save_Data("news", $sdata)) {
  $id = $this->am->Id;
  if ($this->input->post("ujid", TRUE) > 0) {
   $ujdata = array(
     "newsid" => $id,
     "ujid" => $this->input->post("ujid", TRUE)
     );
   $this->am->Save_Data("jelanews", $ujdata);
 }

 write_file("images/myfiles/news_desc_{$id}.txt", $this->input->post("descr"));
 write_file("images/myfiles/news_tag_{$id}.txt", $this->input->post("seo"));
 write_file("images/myfiles/news_meta_description_{$id}.txt", $this->input->post("meta_des"));

 $sdata['status'] = "News Save Successful";
 $this->session->set_userdata($sdata);
 redirect(base_url() . "news-management", "refresh");
} else {
  redirect(base_url() . "news-management", "refresh");
}
}
}

public function view() {
  $data = array();
  $start = $this->uri->segment(3);
  if ($start == NULL) {
   $start = 0;
 } else {
   $start = ($start - 1) * 20;
 }
 $data['title'] = "Famous News 24";
 $data['keywords'] = "";
 $data['description'] = "";
 $data['menu'] = "news";
 $data['allData'] = $this->am->View_Data_Two_Table("news", "menu", "news.*, menu.name", "news.menuid=menu.id", "", array("id", "desc"), array(20, $start));
 $data['allNews'] = $this->am->TotalData("news", "");

 $data['content'] = $this->load->view("admin/news-view", $data, TRUE);
 $this->load->view('admin/master', $data);
}

public function edit($id) {
  $data = array();
  $data['title'] = "Famous News 24";
  $data['keywords'] = "";
  $data['description'] = "";
  $data['menu'] = "news";
  $this->load->library("form_validation");
  $data["allMenu"] = $this->am->View_Data("menu", "*", "", array("name", "asc"), "");
  $data["selNews"] = $this->am->View_Data("news", "*", array("id" => $id), "", "");
  $data['content'] = $this->load->view("admin/news-edit", $data, TRUE);
  $this->load->view('admin/master', $data);
}

public function update() {
  $id = $this->input->post("id");

  $sdata = array(
   "title" => filter($this->input->post("title")),
   "color" => filter($this->input->post("color")),
   "news_source" => filter($this->input->post("news_source")),
   "shoulder_top" => filter($this->input->post("shoulder_top")),
   "shoulder_bottom" => filter($this->input->post("shoulder_bottom")),             
   "head_position" => filter($this->input->post("head_position")),
   "menu_position" => filter($this->input->post("menu_position")),
   "video" => filter($this->input->post("video")),
   "headline" => filter($this->input->post("headline")),
   "breaking" => filter($this->input->post("breaking")),   
   "published" => filter($this->input->post("published")),
   "img_url" => filter($this->input->post("img_url"))
   );

  $menuid = filter($this->input->post("menuid"));
  $submenuid = filter($this->input->post("submenuid"));
  if($menuid == 55){
    $sdata['menuid'] = $submenuid;
  }
  else{
   $sdata['menuid'] = $menuid;
 }
 if ($this->am->Update_Data("news", $sdata, array("id" => $id))) {


  unlink("images/myfiles/news_desc_{$id}.txt");
  unlink("images/myfiles/news_tag_{$id}.txt");
  unlink("images/myfiles/news_meta_description_{$id}.txt");

  write_file("images/myfiles/news_desc_{$id}.txt", $this->input->post("descr"));
  write_file("images/myfiles/news_tag_{$id}.txt", $this->input->post("seo"));
  write_file("images/myfiles/news_meta_description_{$id}.txt", $this->input->post("meta_des"));

  $sdata['status'] = "News Update Successful";
  $this->session->set_userdata($sdata);
  redirect(base_url() . "news-management/view", "refresh");
} else {
 redirect(base_url() . "news-management/view", "refresh");
}
}

public function delete($id) {
  $allData = $this->am->View_Data("news", "*", array("id" => $id), "", "");
  if ($this->am->Delete_Data("news", array("id" => $id))) {
   foreach ($allData as $value) {
    if (file_exists("images/myimages/{$value->id}-{$value->pic_name}.{$value->picture}")) {
     unlink("images/myimages/{$value->id}-{$value->pic_name}.{$value->picture}");
   }
 }
 unlink("images/myfiles/news_desc_{$id}.txt");
 unlink("images/myfiles/news_tag_{$id}.txt");
 unlink("images/myfiles/news_meta_description_{$id}.txt");
 $sdata['status'] = "Delete Successful";
} else {
 $sdata['estatus'] = "This data dependet on other data";
}
$this->session->set_userdata($sdata);
redirect(base_url() . "news-management/view", "refresh");
}

}