<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Adm_picture_management extends CI_Controller {

 public function __construct() {
  parent::__construct();
  $mytype = $this->session->userdata("mytype");
  if ($mytype != 'a' && $mytype != 'o') {
   redirect(base_url(), "refresh");
 }
 date_default_timezone_set("Asia/Dhaka");
}

public function index() {
  $data = array();
  $data['title'] = "Famous News 24";
  $data['keywords'] = "";
  $data['description'] = "";
  $data['menu'] = "news";
  $data['content'] = $this->load->view("admin/picture-new", $data, TRUE);
  $this->load->view('admin/master', $data);
}

public function insert() {
  $data = array();
  

  $ext = pathinfo($_FILES["pic"]["name"]);
  $pic_name = Replace($ext['filename']);
  $ext = strtolower($ext['extension']);
  if ($ext != "jpg" && $ext != "png" && $ext != "jpeg" && $ext != "gif") {
   $ext = "";
   $pic_name = "";
 }
 
 $sdata = array(
   "extension" => $ext,
   "name" => $pic_name
   );

 if ($this->am->Save_Data("news_picture", $sdata)) {
  $id = $this->am->Id;
  if ($ext != "") {
   $this->load->library('upload');
   $config['upload_path'] = './images/news_picture/';
   $config['allowed_types'] = 'gif|jpg|png|jpeg';
   $config['max_size'] = '10000';
   $config['max_width'] = '3000';
   $config['max_height'] = '2000';
   $config['file_name'] = "{$id}-{$pic_name}.{$ext}";
   $this->upload->initialize($config); 
   $this->upload->do_upload('pic');
 }
 $sdata['status'] = "News Save Successful";
 $sdata['img'] = "images/news_picture/{$id}-{$pic_name}.{$ext}";
 $this->session->set_userdata($sdata);
 redirect(base_url() . "picture-management", "refresh");
} else {
  redirect(base_url() . "picture-management", "refresh");
}
}


public function view() {
  $data = array();
  $start = $this->uri->segment(3);
  if ($start == NULL) {
   $start = 0;
 } else {
   $start = ($start - 1) * 20;
 }
 $data['title'] = "Famous News 24";
 $data['keywords'] = "";
 $data['description'] = "";
 $data['menu'] = "news";
 $data['allData'] = $this->am->View_Data("news_picture", "news_picture.*", "", array("id", "desc"), array(20, $start));
 $data['allNews'] = $this->am->TotalData("news_picture", array());

 $data['content'] = $this->load->view("admin/picture-view", $data, TRUE);
 $this->load->view('admin/master', $data);
}


public function delete($id) {
  $allData = $this->am->View_Data("news_picture", "*", array("id" => $id), "", "");
  if ($this->am->Delete_Data("news_picture", array("id" => $id))) {
   foreach ($allData as $value) {
    if (file_exists("images/news_picture/{$value->id}-{$value->name}.{$value->extension}")) {
     unlink("images/news_picture/{$value->id}-{$value->name}.{$value->extension}");
   }
 }
 $sdata['status'] = "Delete Successful";
} else {
 $sdata['estatus'] = "This data dependet on other data";
}

$this->session->set_userdata($sdata);
redirect(base_url() . "picture-management/view", "refresh");
}

}