<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Adm_vote_management extends CI_Controller {

 public function __construct() {
  parent::__construct();
  $mytype = $this->session->userdata("mytype");
  if ($mytype != 'a' && $mytype != 'o') {
   redirect(base_url(), "refresh");
 }
 date_default_timezone_set("Asia/Dhaka");
}

public function index() {
  $data = array();
  $data['title'] = "Amar Sangbad";
  $data['keywords'] = "";
  $data['description'] = "";
  $data['menu'] = "news";
  $data['content'] = $this->load->view("admin/vote-new", $data, TRUE);
  $this->load->view('admin/master', $data);
}

public function insert() {
  $data = array();

  $sdata = array(
    "date" => date("Y-m-d"),
    "v_yes" => 0,
    "v_no" => 0,
    "v_yn" => 0
    );

  if ($this->am->Save_Data("vote", $sdata)) {    
    $id = $this->am->Id;
    write_file("images/vote_files/{$id}.txt", $this->input->post("title"));
    $sdata['status'] = "News Save Successful";
    $this->session->set_userdata($sdata);
    redirect(base_url() . "vote-management", "refresh");
  } 
  else {
    redirect(base_url() . "vote-management", "refresh");
  }
}


public function view() {
  $data = array();
  $start = $this->uri->segment(3);
  if ($start == NULL) {
   $start = 0;
 } else {
   $start = ($start - 1) * 20;
 }
 $data['title'] = "Amar Sangbad";
 $data['keywords'] = "";
 $data['description'] = "";
 $data['menu'] = "news";
 $data['allData'] = $this->am->View_Data("vote", "vote.*", "", array("id", "desc"), array(20, $start));
 $data['allNews'] = $this->am->TotalData("vote", array());

 $data['content'] = $this->load->view("admin/vote-view", $data, TRUE);
 $this->load->view('admin/master', $data);
}

public function edit($id) {
  $data = array();
  $data['title'] = "Amar Sangbad";
  $data['keywords'] = "";
  $data['description'] = "";
  $data['menu'] = "news";
  $this->load->library("form_validation");
  $data["selVote"] = $this->am->View_Data("vote", "*", array("id" => $id), "", "");
  $data['content'] = $this->load->view("admin/vote-edit", $data, TRUE);
  $this->load->view('admin/master', $data);
}

public function update() {
  $id = $this->input->post("id");

  $sdata = array(
    "date" => date("Y-m-d"),
    "v_yes" => 0,
    "v_no" => 0,
    "v_yn" => 0
    );

  if ($this->am->Update_Data("vote", $sdata, array("id" => $id))) {
    unlink("images/vote_files/{$id}.txt");
    write_file("images/vote_files/{$id}.txt", $this->input->post("title"));
    $sdata['status'] = "Vote Update Successful";
    $this->session->set_userdata($sdata);
    redirect(base_url() . "vote-management/view", "refresh");
  } else {
   redirect(base_url() . "vote-management/view", "refresh");
 }
}


public function delete($id) {
  $allData = $this->am->View_Data("vote", "*", array("id" => $id), "", "");
  if ($this->am->Delete_Data("vote", array("id" => $id))) {
   foreach ($allData as $value) {
    if (file_exists("images/vote_files/{$value->id}.txt")) {
     unlink("images/vote_files/{$value->id}.txt");
   }
 }
 $sdata['status'] = "Delete Successful";
} else {
 $sdata['estatus'] = "This data dependet on other data";
}

$this->session->set_userdata($sdata);
redirect(base_url() . "vote-management/view", "refresh");
}

}