<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Category extends CI_Controller {

	public function index()
	{
		$data = array();

		$data['title'] = "Amar Sangbad | Popular bangla news portal in Bangladesh";
		$data['keywords'] = "";
		$data['description'] = "";
		$data['menu'] = "home";
		$this->mbc->BanglaDate(time(), 6);
		$data['today'] = $this->mbc->get_date();
		
		if(isset($_GET['page']) && $_GET['page'] > 1){
			$data["per_page"] = 12;
			$data['page'] = $_GET['page'];
			$data['url'] = base_url() . $this->uri->segment(1) . "/" . $this->uri->segment(2) . "?page=";

			if($this->uri->segment(2) == 55){
				$data['selNews'] = $this->am->bangladesh_pages_news(array($data["per_page"],  ($_GET['page'] -1)* $data["per_page"] ));		

				$data['allData'] = $this->am->bangladesh_pages();
				foreach ($data['allData'][4] as $value) {
					$data['totalNews'] = $value->total;

				}
				$data['content'] = $this->load->view("pages", $data, TRUE);
				$this->load->view('master', $data);
			}
			
			else{
				$data['selNews'] = $this->am->View_Data_Two_Table("news", "menu", "news.id, news.title, menu.ename, news.img_url, news.pic_name, news.picture, news.menuid, menu.name, news.menu_position, news.news_source, news.datetime", "news.menuid=menu.id", array("news.menuid"=>$this->uri->segment(2)) ,array("news.id", "desc"), array($data["per_page"],  ($_GET['page'] -1)* $data["per_page"] ));			

				$data['allData'] = $this->am->category_pages($this->uri->segment(2));
				foreach ($data['allData'][4] as $value) {
					$data['totalNews'] = $value->total;
				}

				$data['content'] = $this->load->view("pages", $data, TRUE);
				$this->load->view('master', $data);
			}	
		}
		else{
			if($this->uri->segment(2) == 55){
				$data['allData'] = $this->am->bangladesh();
				$data['content'] = $this->load->view("category", $data, TRUE);
				$this->load->view('master', $data);
			}				
			else{
				$data['allData'] = $this->am->category($this->uri->segment(2));
				$data['content'] = $this->load->view("category", $data, TRUE);
				$this->load->view('master', $data);
			}	
		}
	}
	public function articles($id){
		$data = array();
		$data['title'] = "Amar Sangbad | Popular bangla news portal in Bangladesh";
		$data['keywords'] = "";
		$data['description'] = "";
		$data['menu'] = "home";
		$this->mbc->BanglaDate(time(), 6);
		$data['today'] = $this->mbc->get_date();
		$data['allData'] = $this->am->articles($id);



		if(!isset($data['allData'][3]) || !$data['allData'][3]){
			redirect(base_url(),'refresh');
		}

		foreach ($data['allData'][3] as $value) {
			$data['title'] = $value->title;
			$data['keywords'] = trim(strip_tags(read_file("./images/myfiles/news_tag_{$value->id}.txt")));
			$data['description'] = trim(strip_tags(read_file("./images/myfiles/news_meta_description_{$value->id}.txt")));
			$data['menu'] = $value->ename;

			$data['og_title'] = $value->title;
			$data['og_desc'] = My_WordCount(read_file("./images/myfiles/news_desc_{$value->id}.txt"), 40);
			$data['og_url'] = base_url() . $this->uri->segment(1) . "/" . $this->uri->segment(2) . "/" . $this->uri->segment(3) . "/" . ReplaceTitle($value->title);
			$texthtml = read_file("images/myfiles/news_desc_" . $value->id . ".txt");
			preg_match('/<img.+src=[\'"](?P<src>.+?)[\'"].*>/i', $texthtml, $image);

			if($value->img_url){
				$data['og_image'] = $value->img_url;
			}
			else if($value->picture){
				$data['og_image'] = base_url() . "images/myimages/" . $value->id . "-" . $value->pic_name . "." . $value->picture;
			}
			else {
				$data['og_image'] = $image['src'];	
			}
		}

		if (isset($_GET['print']) && $_GET['print'] == 1) {			
			$this->load->view('print', $data);
		} else {
			$data['content'] = $this->load->view("articles", $data, TRUE);
			$this->load->view('master', $data);
		}

		
	}

}

/* End of file Category.php */
/* Location: ./application/controllers/Category.php */