<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Details extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model("model_table", "mt", TRUE);
        $this->load->model("model_bangla_calendar", "mbc", TRUE);
        date_default_timezone_set('Asia/Dhaka');
    }

    public function index() {
        $data = array();
        ini_set('memory_limit', '-1');
        $this->mbc->BanglaDate(time(), 6);
        $data['today'] = $this->mbc->get_date();
        $data['allDivision'] = $this->mt->OnlyData("select * from division order by id asc");
        $data['allJela'] = $this->mt->OnlyData("select * from jela order by id asc");
        $data['allUpoJela'] = $this->mt->OnlyData("select * from upojela order by id asc");

        $selected = $this->mt->OnlyData("select * from news where id='" . MS($this->uri->segment(3)) . "'");
        if ($selected == "") {
            redirect(base_url(), "refresh");
        }
        $this->mt->update_data("news", array("visit" => ($selected[0][8] + 1)), array("id" => $selected[0][0]));

        $data['selected'] = $selected;
        $data['active'] = $selected[0][9];
        $data['meta_title'] = "{$selected[0][1]} | Popular Bangla Online Newspaper";
        $data['meta_keyword'] = read_file("images/myfiles/news_tag_" . $selected[0][0] . ".txt");
        $data['meta_description'] = read_file("images/myfiles/news_meta_description_" . $selected[0][0] . ".txt");


        $data['og_image'] = "{$selected[0][0]}-{$selected[0][15]}.{$selected[0][2]}";
        $data['og_title'] = $selected[0][1];
        $data['og_desc'] = My_WordCount("images/myfiles/news_desc_" . $selected[0][0] . ".txt", 50);
        $data['og_url'] = $this->uri->segment(1) . "/" . $this->uri->segment(2) . "/" . $this->uri->segment(3);


        $data['menu'] = $this->mt->OnlyData("select * from menu order by serial1 asc");
        $data['latest'] = $this->mt->OnlyData("select news.*, menu.name, menu.ename, menu.serial2 
                                                    from news, menu
                                                    where news.menuid = menu.id  
                                                    order by news.id desc");
        $data['mostRead'] = $this->mt->OnlyData("select news.*, menu.name, menu.ename 
                                                    from news, menu
                                                    where news.menuid = menu.id and 
														news.datetime between '" . date("Y-m-d H:i:s", strtotime("yesterday")) . "' and '" . date("Y-m-d 23:59:59") . "'
                                                    order by news.visit desc limit 12");
        $data['content'] = $this->load->view("details", $data, TRUE);
        $this->load->view('master', $data);
    }

}

?>