<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
class Division_Management extends CI_Controller {
    public function __construct() {
         parent::__construct();
         
         $myid = $this->session->userdata("myid");
         $mytype = $this->session->userdata("mytype");         
         if($myid == NULL || $mytype != 'a'){
             redirect(base_url(), "refresh");
         }
         $this->load->model("model_table", "mt", TRUE);
    }    
    
    public function index(){
       $data = array();
       $data['title'] = "Division Management";
       $data['menu'] = 'div';
       $data['center'] = $this->load->view("admin/division_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    public function view(){
       $data = array();
       $data['title'] = "Division Management";
       $data['menu'] = 'div';
       $data['SelectAll'] = $this->mt->OnlyData("select * from division order by id asc");
       $data['center'] = $this->load->view("admin/division_view", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    public function new_division()
    {
       $msg = "";
       $err = 0;
       if($this->input->post("name") == ""){
          $msg .= ++$err . ". Division Name Required<br>";            
       }
       if($err == 0) {
           $data = array();          
           $svdata = array(
               'name'      => $this->input->post("name")
           );           
           if($this->mt->Insert("division", $svdata, array('name' => $this->input->post("name")))) {             
            $sdata['status'] = "Saved Successful";             
           }
           else{
               $sdata['estatus'] = "Division name already exist";
           }           
       }else{
           $sdata['estatus'] = $msg;
       } 
      $this->session->set_userdata($sdata);
      redirect(base_url() . "division_management", "refresh");
    }
    
    public function edit($division_id)
    {
        $data = array();
        $this->mt->Id = $division_id;
        $data['Selected'] = $this->mt->SelectedById("division", $division_id);         
        $data['title'] = "Division Management";
        $data['menu'] = 1;
        $data['center'] = $this->load->view("admin/division_new", $data, TRUE);
        $this->load->view("admin/admin_master", $data);
    }
    
    public function update($id)
    {
       $msg = "";
       $err = 0;
       if($this->input->post("name") == ""){
          $msg .= ++$err . ". Division Name Required<br>";            
       }
       if($err == 0) {
           $svdata = array(
               'name'      => $this->input->post("name")
           );            
           if($this->mt->Update("division", $svdata, array('id' => $id))) {
              $sdata['status'] = "Update Successful";             
           }
           else{
               $sdata['estatus'] = "Division name already exist";
           }           
       }else{
           $sdata['estatus'] = $msg;
       }       
      $this->session->set_userdata($sdata);
      redirect(base_url() . "division_management/view", "refresh");
    }
    
    public function delete($id)
    {
        $this->mt->Id = $id;
        if($this->mt->delete_data("division", array("id"=>$id))) {
            $sdata['status'] = "Delete Successful";             
        }
        else{
            $sdata['estatus'] = "This Division dependet on other data";
        }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "division_management/view", "refresh");
    }
    
}

?>
