<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
class Menu_Management extends CI_Controller {
    public function __construct() {
         parent::__construct();
         
         $myid = $this->session->userdata("myid");
         $mytype = $this->session->userdata("mytype");         
         if($myid == NULL || $mytype != 'a'){
             redirect(base_url(), "refresh");
         }
         
         $this->load->model("model_menu", "m_menu", TRUE);
         $this->load->model("model_table", "mt", TRUE);
    }    
    
    public function index(){
       $data = array();
       $data['title'] = "Menu Management";
       $data['menu'] = 'menu';
       $data['center'] = $this->load->view("admin/menu_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    public function view(){
       $data = array();
       $data['title'] = "Menu Management";
       $data['menu'] = 'menu';
       $data['SelectAll'] = $this->m_menu->Select();
       $data['center'] = $this->load->view("admin/menu_view", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    public function new_menu()
    {
       $msg = "";
       $err = 0;
       if($this->input->post("name") == ""){
          $msg .= ++$err . ". Menu Name Required<br>";            
       }
       if($this->input->post("serial1") == ""){
          $msg .= ++$err . ". Menu Serial Required<br>";            
       } 
       if($this->input->post("serial2") == ""){
          $msg .= ++$err . ". Page Serial Required<br>";            
       } 
       if($this->input->post("ename") == ""){
          $msg .= ++$err . ". Menu Name(english) Required<br>";            
       }
       if($err == 0) {
           $data = array();          
           $svdata = array(
               'name'      => $this->input->post("name"),
               'serial1'   => $this->input->post("serial1"),
               'serial2'   => $this->input->post("serial2"),
               'ename'     => $this->input->post("ename")
           );           
           if($this->mt->Insert("menu", $svdata, array('name' => $this->input->post("name")))) {
              $svdata = array();
              $svdata = array(
                  'controller' => "category",
                  'menuid' => $this->mt->Id
              ); 
              
            $this->mt->Insert("routes_menu", $svdata, array('menuid' => $this->mt->Id)); //name, field, exist
            $sdata['status'] = "Saved Successful";             
           }
           else{
               $sdata['estatus'] = "Menu name already exist";
           }           
       }else{
           $sdata['estatus'] = $msg;
       } 
      $this->session->set_userdata($sdata);
      redirect(base_url() . "menu_management", "refresh");
    }
    
    public function edit($menu_id)
    {
        $data = array();
        $this->m_menu->Id = $menu_id;
        $data['Selected'] = $this->m_menu->SelectById($menu_id);         
        $data['title'] = "Menu Management";
        $data['menu'] = 1;
        $data['center'] = $this->load->view("admin/menu_new", $data, TRUE);
        $this->load->view("admin/admin_master", $data);
    }
    
    public function update($id)
    {
       $msg = "";
       $err = 0;
       if($this->input->post("name") == ""){
          $msg .= ++$err . ". Menu Name Required<br>";            
       }
       if($this->input->post("serial1") == ""){
          $msg .= ++$err . ". Menu Serial Required<br>";            
       } 
       if($this->input->post("serial2") == ""){
          $msg .= ++$err . ". Page Serial Required<br>";            
       } 
       if($err == 0) {
           $svdata = array(
               'name'      => $this->input->post("name"),
               'serial1'   => $this->input->post("serial1"),
               'serial2'   => $this->input->post("serial2"),
               'ename'     => $this->input->post("ename")
           );            
           if($this->mt->Update("menu", $svdata, array('id' => $id))) {
              $sdata['status'] = "Update Successful";             
           }
           else{
               $sdata['estatus'] = "Menu name already exist";
           }           
       }else{
           $sdata['estatus'] = $msg;
       }       
      $this->session->set_userdata($sdata);
      redirect(base_url() . "menu_management/view", "refresh");
    }
    
    public function delete($id)
    {
        $this->m_menu->Id = $id;
        $this->mt->Delete("routes_menu", array('menuid' => $id));        
        if($this->m_menu->Delete()) {
            $sdata['status'] = "Delete Successful";             
        }
        else{
            $sdata['estatus'] = "This Menu dependet on other data";
            $svdata = array();
            $svdata = array(
                  'controller' => "category",
                  'menuid' => $id
            );               
            $this->mt->Insert("routes_menu", $svdata, array('menuid' => $id)); //name, field, exist
        }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "menu_management/view", "refresh");
    }
    
    public function delete_all()
    {
       $count = 0;
       $id = "";
       $x = $this->input->post('all');
       if($this->input->post('all') != NULL){
            foreach ($x as $value) {
              if($count > 0) {
                 $id .= ", ";
              }
              $count = 1;
              $id .= $value;
            }
            $this->m_menu->Id = $id;
            if($this->m_menu->Delete()) {
                $sdata['status'] = "Delete Successful";             
            }
            else{
                $sdata['estatus'] = "This Menu dependet on other data";
            }
       }else {
          $data['estatus'] = "Pls select any item";
       }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "menu_management", "refresh");
    }
    
}

?>
