<?php

if (!defined('BASEPATH'))
   exit('No direct script access allowed');

class News extends CI_Controller {

   public function __construct() {
      parent::__construct();
      $this->load->model("model_table", "mt", TRUE);
      $this->load->model("model_bangla_calendar", "mbc", TRUE);
      date_default_timezone_set('Asia/Dhaka');
   }

   public function index() {
      $data = array();
      $data['active'] = "home";
      $data['active'] = "p1";
      $data['date'] = date("Y-m-d");
      $data['meta_title'] = "amar-sangbad.com | Popular Bangla Newspaper";
      $data['meta_keyword'] = "banglanews, bangla news, bangladeshi news, today news24, daily news, bangla news daily, bd news, bd news headlines, news headlines, all bangla newspaper, live newspaper headlines";
      $data['meta_description'] = "amar-sangbad.com is one of the most reliable and popular bangla online news portal. We provide latest news about various categories for 24/7 days.";
      $data['pages'] = $this->mt->OnlyData("select * from pages where page_number = 1 and date = '" . date("Y-m-d") . "' order by date desc limit 1");
      $data['content'] = $this->load->view("ehome", $data, TRUE);
      $this->load->view('emaster', $data);
   }

   public function pages() {
      $data = array();
      $data['active'] = "home";
      $ids = $this->uri->segment(3);
      $date = $this->uri->segment(2);
      $data['meta_title'] = "amar-sangbad.com | Popular Bangla Newspaper";
      $data['meta_keyword'] = "banglanews, bangla news, bangladeshi news, today news24, daily news, bangla news daily, bd news, bd news headlines, news headlines, all bangla newspaper, live newspaper headlines";
      $data['meta_description'] = "amar-sangbad.com is one of the most reliable and popular bangla online news portal. We provide latest news about various categories for 24/7 days.";
      
      if($data != NULL){
         $data['date'] = $date;
      }
      else{
         $data['date'] = date("Y-m-d");
      }
      
      if($data == NULL){
         $ids = 1;
      }
      $data['active'] = "p{$ids}";
      
      $data['pages'] = $this->mt->OnlyData("select * from pages where page_number = {$ids} and date = '" . $data["date"] . "' order by date desc limit 1");
      
      if(!$data['pages']){
         redirect(base_url(), "refresh");
      }
      
      
      
      $data['content'] = $this->load->view("ehome", $data, TRUE);
      $this->load->view('emaster', $data);
   }

   public function page() {
      $data = array();
      $this->mbc->BanglaDate(time(), 6);
      $data['today'] = $this->mbc->get_date();
      $data['active'] = "p{$this->uri->segment(3)}";
      $data['meta_title'] = "amar-sangbad.com | Popular Bangla Newspaper";
      $data['meta_keyword'] = "banglanews, bangla news, bangladeshi news, today news24, daily news, bangla news daily, bd news, bd news headlines, 
									news headlines, all bangla newspaper, live newspaper headlines";
      $data['meta_description'] = "amar-sangbad.com is one of the most reliable and popular bangla online news portal. We provide latest news 
						about various categories for 24/7 days.";
      $data['pages'] = $this->mt->OnlyData("select * from pages where page_number = '" . MS($this->uri->segment(3)) . "' and date = '" . date("Y-m-d") . "' order by date desc limit 1");
      if ($data['pages'] == "") {
         redirect(base_url(), "refresh");
      }
      $data['content'] = $this->load->view("ehome", $data, TRUE);
      $this->load->view('emaster', $data);
   }

   public function all_page() {
      $data = array();
      $this->mbc->BanglaDate(time(), 6);
      $data['today'] = $this->mbc->get_date();
      $data['active'] = "p13";
      $data['meta_title'] = "amar-sangbad.com | Popular Bangla Newspaper";
      $data['meta_keyword'] = "banglanews, bangla news, bangladeshi news, today news24, daily news, bangla news daily, bd news, bd news headlines, 
									news headlines, all bangla newspaper, live newspaper headlines";
      $data['meta_description'] = "amar-sangbad.com is one of the most reliable and popular bangla online news portal. We provide latest news 
						about various categories for 24/7 days.";
      $data['pages'] = $this->mt->OnlyData("select * from pages where date = '" . date("Y-m-d") . "' order by page_number asc");
      if ($data['pages'] == "") {
         redirect(base_url(), "refresh");
      }
      $data['content'] = $this->load->view("epages", $data, TRUE);
      $this->load->view('emaster', $data);
   }

   public function search() {
      $data = array();
      $this->mbc->BanglaDate(time(), 6);
      $data['today'] = $this->mbc->get_date();
      $data['active'] = "p{$this->uri->segment(3)}";
      $data['meta_title'] = "amar-sangbad.com | Popular Bangla Newspaper";
      $data['meta_keyword'] = "banglanews, bangla news, bangladeshi news, today news24, daily news, bangla news daily, bd news, bd news headlines, 
									news headlines, all bangla newspaper, live newspaper headlines";
      $data['meta_description'] = "amar-sangbad.com is one of the most reliable and popular bangla online news portal. We provide latest news 
						about various categories for 24/7 days.";
      $sql = "select * from pages 
                                    where date = '" . $_POST['year'] . "-" . $_POST['month'] . "-" . $_POST['day'] . "' 
                                        order by page_number asc limit 12";
      $data['pages'] = $this->mt->OnlyData($sql);
      if ($data['pages'] == "") {
         redirect(base_url(), "refresh");
      }
      $data['content'] = $this->load->view("epages", $data, TRUE);
      $this->load->view('emaster', $data);
   }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */