<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class News_Management extends CI_Controller{
    //put your code here
    public function __construct() {
        parent::__construct();
        $myid = $this->session->userdata("myid");
        $mytype = $this->session->userdata("mytype");    
         if($myid == NULL || $mytype == 'e'){
             redirect(base_url(), "refresh");
         }
        $this->load->model("model_myclass", "mmc", TRUE);
        $this->load->model("model_table", "mt", TRUE);
	date_default_timezone_set('Asia/Dhaka');
    }
    
    public function index()
    {
       $data = array();
       $data['title'] = "News Management";
       $data['menu'] = 'news';
       
       $data['allDivision'] = $this->mt->OnlyData("select * from division order by id asc");
       $data['allJela'] = $this->mt->OnlyData("select * from jela order by id asc");
       $data['allUpoJela'] = $this->mt->OnlyData("select * from upojela order by id asc");
       
       $data['SelectAll'] = $this->mt->OnlyData("select * from menu order by serial1 asc");
       $data['center'] = $this->load->view("admin/news_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    
    public function insert()
    {
        $org_name= "";
        $org_ext = $this->mmc->CheckExtension($_FILES['pic']['name']);
        if($org_ext) {           
            $pp = pathinfo($_FILES['pic']['name']);
            $org_name = My_Replace(strtolower($pp['filename']));
         }
         
        $sdata = array(
                'title'         => $this->input->post("title", TRUE),
                'picture'       => $org_ext,
                'video'         => $this->input->post("video", TRUE),
                'first_page'    => $this->input->post("first_page", TRUE),
                'marquee'       => $this->input->post("marid", TRUE),
                'datetime'      => date("Y-m-d H:i:s"),
                'visit'         => 0,
                'menuid'        => $this->input->post("menuid", TRUE),
                'breaking'      => $this->input->post("breaking", TRUE),
                'shoulder'      => $this->input->post("shoulder", TRUE),
                'nirbachito'    => $this->input->post("nirbachito", TRUE),
                'pic_name'      => $org_name,
                'publisher'     => $this->input->post("publisher", TRUE),
                'published'     => $this->input->post("published", TRUE)
            );         
         
         if($this->mt->save_data("news", $sdata)){
            if($this->input->post("upojelaid", TRUE) > 0){
               $ffdata = array(
                  "newsid"  =>   $this->mt->Id,
                  "ujid"    =>   $this->input->post("upojelaid", TRUE)
               );
               $this->mt->save_data("jelanews", $ffdata);
            } 
             
            write_file("images/myfiles/news_desc_{$this->mt->Id}.txt", $this->input->post("des"));           
            write_file("images/myfiles/news_tag_{$this->mt->Id}.txt", $this->input->post("seo"));           
            write_file("images/myfiles/news_meta_description_{$this->mt->Id}.txt", $this->input->post("meta_des"));           
            
            if($org_ext != ""){
               $this->mmc->UploadImage('pic', "images/myimages/", "{$this->mt->Id}-{$org_name}.{$org_ext}");                                        
               //$this->mmc->watermark("news_{$this->m_news->Id}{$org_name}.{$this->m_news->Picture}", "images/myimages/");   
            }
            $sdata['status'] = "News Save Successful";
            redirect(base_url() . "news_management", "refresh");
         }else{  
               $sdata['estatus'] = "Server Too Busy";
               $this->session->set_userdata($sdata);
               redirect(base_url()."news_management", "refresh");
         }
           
    }
    
    public function view()
    {
       $data = array();       
       $data['title'] = "News Management";
       $data['menu'] = 'news';
       $start = $this->uri->segment(3);
       if($start > 1){
           $data['start'] = ($start-1) * 25;
       }else{
           $data['start'] = 0;
       }
       
       $sql = "select news.*, menu.name     
               from news, menu
               where news.menuid = menu.id";
       $sql .= " order by news.id desc";
       $data['SelectAll'] = $this->mt->OnlyData($sql);       
       $data['center'] = $this->load->view("admin/news_view", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
     public function edit()
    {
       $data = array();
       $data['title'] = "News Management";
       $data['menu'] = 'news';
       $data['SelectAll'] = $this->mt->OnlyData("select * from menu order by serial1 asc");
       $data['Selected'] = $this->mt->SelectedById("news", $this->uri->segment(3));
       
       $data['allDivision'] = $this->mt->OnlyData("select * from division order by id asc");
       $data['allJela'] = $this->mt->OnlyData("select * from jela order by id asc");
       $data['allUpoJela'] = $this->mt->OnlyData("select * from upojela order by id asc");
       $r = $this->mt->OnlyData("select uj.id, j.id, d.id 
                 from upojela as uj, jela as j, division as d, jelanews as jn
                 where jn.ujid = uj.id and uj.jelaid = j.id and j.divisionid = d.id and jn.newsid = '".MS($this->uri->segment(3))."'");
       if($r){
           $data['allDivJelUjel'] = $r;
           $data['jelaList'] = $this->mt->OnlyData("select * from jela where divisionid='".$r[0][2]."'");
           $data['upojelaList'] = $this->mt->OnlyData("select * from upojela where jelaid='".$r[0][1]."'");
       }
       
       $data['center'] = $this->load->view("admin/news_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    public function Update()
    {
        $d = $this->mt->SelectedById("news", $this->uri->segment(3));         
        
        $org_name = ""; 
        $ext = $this->mmc->CheckExtension($_FILES['pic']['name']);         
        if($ext != ""){
               $pp = pathinfo($_FILES['pic']['name']);
               $org_name = My_Replace(strtolower($pp['filename']));                  
               unlink("images/myimages/{$this->uri->segment(3)}-{$d[15]}.{$d[2]}");
               $this->mmc->UploadImage('pic', "images/myimages/", "{$this->uri->segment(3)}-{$org_name}.{$ext}");                                        
               //$this->mmc->watermark("news_{$this->m_news->Id}{$org_name}.{$this->m_news->Picture}", "images/myimages/");   
        }else{
            $ext = $d[2];
            $org_name = $d[15];
        }
        
        $sdata = array(
                'title'         => $this->input->post("title", TRUE),
                'picture'       => $ext,
                'video'         => $this->input->post("video", TRUE),
                'first_page'    => $this->input->post("first_page", TRUE),
                'marquee'       => $this->input->post("marid", TRUE),
                'menuid'        => $this->input->post("menuid", TRUE),
                'breaking'      => $this->input->post("breaking", TRUE),
                'shoulder'      => $this->input->post("shoulder", TRUE),
                'nirbachito'     => $this->input->post("nirbachito", TRUE),
                'pic_name'      => $org_name,
                'publisher'     => $this->input->post("publisher", TRUE),
                'published'     => $this->input->post("published", TRUE)
            );              
         if($this->mt->update_data("news", $sdata, array("id"=>$this->uri->segment(3)))){
            if($this->input->post("upojelaid", TRUE) > 0){
               $d = $this->mt->data_selectid("jelanews", array("newsid"=>$this->uri->segment(3)));
               if($d){
                  $data = array(                  
                     "ujid"    =>  $this->input->post("upojelaid", TRUE)
                  );
                  $this->mt->update_data("jelanews", $data, array("newsid"=>$this->uri->segment(3)));
               }else{
                  $data = array(
                     "newsid"  =>   $this->uri->segment(3),
                     "ujid"    =>   $this->input->post("upojelaid", TRUE)
                  );
                  $this->mt->save_data("jelanews", $data);
               }
            }else{
               $this->mt->delete_data("jelanews", array("newsid"=>$this->uri->segment(3)));
            }
            unlink("images/myfiles/news_desc_{$this->uri->segment(3)}.txt");
            unlink("images/myfiles/news_tag_{$this->uri->segment(3)}.txt");
            unlink("images/myfiles/news_meta_description_{$this->uri->segment(3)}.txt");
			
            write_file("images/myfiles/news_desc_{$this->uri->segment(3)}.txt", $this->input->post("des"));           
            write_file("images/myfiles/news_tag_{$this->uri->segment(3)}.txt", $this->input->post("seo")); 
            write_file("images/myfiles/news_meta_description_{$this->uri->segment(3)}.txt", $this->input->post("meta_des"));          
         }
         $sdata['status'] = "Update Successful";
        
        $this->session->set_userdata($sdata);
        redirect(base_url()."news_management/view", "refresh");  
    }
    
    public function delete($id)
    {
        $this->mt->delete_data("jelanews", array("newsid" => $id));
        $d = $this->mt->SelectedById("news", $id);
        if($this->mt->delete_data("news", array("id"=>$id))) {
           unlink("images/myfiles/news_desc_{$d[0]}.txt");
           unlink("images/myfiles/news_tag_{$d[0]}.txt");
           unlink("images/myfiles/news_meta_description_{$d[0]}.txt");
           if($d[2] != ""){
               unlink("images/myimages/{$d[0]}-{$d[15]}.{$d[2]}");
           }
           $sdata['status'] = "Delete Successful";             
        }
        else{
            $sdata['estatus'] = "This data dependet on other data";
        }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "news_management/view", "refresh");
    }
}
?>