<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class News_Picture_Management extends CI_Controller{
    //put your code here
    public function __construct() {
        parent::__construct();
        $myid = $this->session->userdata("myid");
        $mytype = $this->session->userdata("mytype");    
         if($myid == NULL || $mytype == 'e'){
             redirect(base_url(), "refresh");
         }
        $this->load->model("model_myclass", "mmc", TRUE);
        $this->load->model("model_table", "mt", TRUE);
    }
    
    public function index()
    {
       $data = array();
       $data['title'] = "News Management";
       $data['menu'] = 'picture';
       
       $data['center'] = $this->load->view("admin/news_picture_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    
    public function insert()
    {
        $org_name= "";
        $org_ext = $this->mmc->CheckExtension($_FILES['pic']['name']);
        if($org_ext) {           
            $pp = pathinfo($_FILES['pic']['name']);
            $org_name = My_Replace(strtolower($pp['filename']));
         }         
        $sdata = array(
            'extension'       => $org_ext,
            'name'      => $org_name
        );
        if($org_ext != "") {
            if($this->mt->save_data("news_picture", $sdata)){            
                $sdata['ext'] = "{$this->mt->Id}-{$org_name}.{$org_ext}";
                $sdata['status'] = "Upload Successful";
                $this->mmc->UploadImage('pic', "images/news_picture/", "{$this->mt->Id}-{$org_name}.{$org_ext}");                                        
                $this->session->set_userdata($sdata);
            }else{                   
                $sdata['estatus'] = "Server Too Busy";
                $this->session->set_userdata($sdata);
                  
            }
        }else{
            $sdata['estatus'] = "Invalid Format";
            $this->session->set_userdata($sdata);
        }
        
        redirect(base_url()."news_picture_management", "refresh");   
    }
    
    public function view()
    {
       $data = array();       
       $data['title'] = "News Management";
       $data['menu'] = 'picture';
       $sql = "select * from news_picture order by id desc";
       $data['SelectAll'] = $this->mt->OnlyData($sql);       
       $data['center'] = $this->load->view("admin/news_picture_view", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    
    public function delete($id)
    {
        $d = $this->mt->SelectedById("news_picture", $id);
        if($this->mt->delete_data("news_picture", array("id"=>$id))) {
           if($d[2] != ""){
               unlink("images/news_picture/{$d[0]}-{$d[1]}.{$d[2]}");
           }
           $sdata['status'] = "Delete Successful";             
        }
        else{
            $sdata['estatus'] = "This data dependet on other data";
        }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "news_picture_management/view", "refresh");
    }
    
   
     
}

?>
