<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Page_Management extends CI_Controller{
    //put your code here
    public function __construct() {
        parent::__construct();
        $myid = $this->session->userdata("myid");
         if($myid == NULL){
             redirect(base_url(), "refresh");
         }
        $this->load->model("model_myclass", "mmc", TRUE);
        $this->load->model("model_table", "mt", TRUE);
	date_default_timezone_set('Asia/Dhaka');
    }
    
    public function index()
    {
       $data = array();
       $data['title'] = "Page Management";
       $data['menu'] = 'page';
       $data['center'] = $this->load->view("admin/page_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    
    public function insert()
    {       
        $ext = $this->mmc->CheckExtension($_FILES['pic']['name']);
        if($ext) {  
            $sdata = array(
                'picture'         => $ext,
                'page_number'     => $this->input->post("page_number", TRUE),
                'date'            => My_DateCorrectFormat($this->input->post("date", TRUE))
            );
            $exist = array('page_number'    =>  $this->input->post("page_number", TRUE),
                            'date'          =>  My_DateCorrectFormat($this->input->post("date", TRUE)));
            if($this->mt->Insert("pages", $sdata, $exist)){                       
               if($ext != ""){
                  $this->mmc->UploadImage('pic', "images/epaper/", "1_{$this->mt->Id}.{$ext}");                  $this->mmc->My_Thumbnail2("images/epaper/1_{$this->mt->Id}.{$ext}", "images/epaper/{$this->mt->Id}.{$ext}", 1347, 2165);   
				  unlink("images/epaper/1_{$this->mt->Id}.{$ext}");                   
               }
               $sdata['status'] = "Page Upload Successful";               
            }else{                
                  $sdata['estatus'] = "Page Already Uploaded";
            }
        }
        else{
             $sdata['estatus'] = "Invalid Picture Format";
        }        
        $this->session->set_userdata($sdata);
        redirect(base_url()."page_management", "refresh");           
    }
    
    public function view()
    {
       $data = array();       
       $data['title'] = "Page Management";
       $data['menu'] = 'page';

       $start = $this->uri->segment(3);
       if($start > 1){
           $start = ($start-1) * 30;
       }else{
           $start = 0;
       }

       $sql = "select * from pages order by date desc limit $start, 30";
       $data['SelectAll'] = $this->mt->OnlyData($sql);    
       $data["totalpage"] = $this->mt->OnlyData("select count(id) id from pages");

       $data['center'] = $this->load->view("admin/page_view", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
     public function edit()
    {
       $data = array();
       $data['title'] = "Page Management";
       $data['menu'] = 'page';
       $data['Selected'] = $this->mt->SelectedById("pages", $this->uri->segment(3));
       
       $data['center'] = $this->load->view("admin/page_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    public function Update()
    {
        $d = $this->mt->SelectedById("pages", $this->uri->segment(3));    
        $ext = $this->mmc->CheckExtension($_FILES['pic']['name']);         
        if($ext != ""){                                 
            if($d[1]){
                if(file_exists("images/epaper/{$d[0]}.{$d[1]}")){
                    unlink("images/epaper/{$d[0]}.{$d[1]}");
                }
            }
            $this->mmc->UploadImage('pic', "images/epaper/", "{$this->uri->segment(3)}.{$ext}");                                        
        }else{
            $ext = $d[1];
        }        
        $sdata = array(
                'picture'         => $ext,
                'page_number'     => $this->input->post("page_number", TRUE),
                'date'            => My_DateCorrectFormat($this->input->post("date", TRUE))
            );
         if($this->mt->update_data("pages", $sdata, array("id"=>$this->uri->segment(3)))){
             $sdata['status'] = "Update Successful";
         }else{
              $sdata['estatus'] = "Page Already Uploaded";
         }
        $this->session->set_userdata($sdata);
        redirect(base_url()."page_management/view", "refresh");  
    }
    
    public function delete($id)
    {
        $d = $this->mt->SelectedById("pages", $id);
        if($this->mt->delete_data("pages", array("id"=>$id))) {          
           if($d[1] != "" && file_exists("images/epaper/{$d[0]}.{$d[1]}")){
               unlink("images/epaper/{$d[0]}.{$d[1]}");
           }
           $sdata['status'] = "Delete Successful";             
        }
        else{
            $sdata['estatus'] = "This data dependet on other data";
        }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "page_management/view", "refresh");
    }    
}

?>
