<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vote_Management extends CI_Controller{
    //put your code here
    public function __construct() {
        parent::__construct();
        $myid = $this->session->userdata("myid");
        $mytype = $this->session->userdata("mytype");    
         if($myid == NULL || $mytype == 'e'){
             redirect(base_url(), "refresh");
         }
        $this->load->model("model_myclass", "mmc", TRUE);
        $this->load->model("model_table", "mt", TRUE);
	date_default_timezone_set('Asia/Dhaka');
    }
    
    public function index()
    {
       $data = array();
       $data['title'] = "Vote Management";
       $data['menu'] = 'vote';       
       $data['center'] = $this->load->view("admin/vote_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    
    public function insert()
    {
       $msg = "";
       $err = 0;
       
       if($this->input->post("name") == ""){
          $msg .= ++$err . ". Name Required<br>";            
       }  
       if($err == 0) {        
            $sdata = array(
                'date'  => My_DateCorrectFormat($this->input->post("date"))
            );
            if($this->mt->save_data("vote", $sdata)){      
               write_file("images/vote_files/{$this->mt->Id}.txt", $this->input->post("name"));            
               $sdata['status'] = "Vote Topic Save Successful";              
            }else{                  
                  $sdata['estatus'] = "Server Too Busy";
            }
        }
        else{
            $sdata['estatus'] = $msg;
        }
         $this->session->set_userdata($sdata);
         redirect(base_url() . "vote_management", "refresh");
    }
    
    public function view()
    {
       $data = array();       
       $data['title'] = "Vote Management";
       $data['menu'] = 'vote';
       $this->m_news->Published = 1;
       $sql = "select * from vote order by date desc";
       $data['SelectAll'] = $this->mt->OnlyData($sql);       
       $data['center'] = $this->load->view("admin/vote_view", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
     public function edit()
    {
       $data = array();
       $data['title'] = "News Management";
       $data['menu'] = 'news';
       $data['Selected'] = $this->mt->SelectedById("vote", $this->uri->segment(3));
       
       $data['center'] = $this->load->view("admin/vote_new", $data, TRUE);
       $this->load->view("admin/admin_master", $data);
    }
    
    public function Update()
    {
        
        $msg = "";
       $err = 0;
       
       if($this->input->post("name") == ""){
          $msg .= ++$err . ". Name Required<br>";            
       }  
       if($err == 0) {        
            $sdata = array(
                'date'  => My_DateCorrectFormat($this->input->post("date"))
            );
            if($this->mt->update_data("vote", $sdata, array("id"=>$this->uri->segment(3)))){
               unlink("images/vote_files/{$this->uri->segment(3)}.txt"); 
               write_file("images/vote_files/{$this->uri->segment(3)}.txt", $this->input->post("name"));            
               $sdata['status'] = "Vote Topic Update Successful";              
            }else{                  
                  $sdata['estatus'] = "Server Too Busy";
            }
        }
        else{
            $sdata['estatus'] = $msg;
        }
         $this->session->set_userdata($sdata);
         redirect(base_url() . "vote_management/view", "refresh");         
    }
    
    public function delete($id)
    {
        $d = $this->mt->SelectedById("news", $id);
        if($this->mt->delete_data("news", array("id"=>$id))) {
           unlink("images/myfiles/news_desc_{$d[0]}.txt");
           unlink("images/myfiles/news_tag_{$d[0]}.txt");
           unlink("images/myfiles/news_meta_description_{$d[0]}.txt");
           if($d[2] != ""){
               unlink("images/myimages/{$d[0]}-{$d[15]}.{$d[2]}");
           }
           $sdata['status'] = "Delete Successful";             
        }
        else{
            $sdata['estatus'] = "This data dependet on other data";
        }
           
        $this->session->set_userdata($sdata);
        redirect(base_url() . "news_management/view", "refresh");
    }
    
   
     
}

?>
