<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Amar_Model extends CI_Model {

   public $Id;

   public function Save_Data($table, $data) {
      if ($this->db->insert($table, $data)) {
         $this->Id = $this->db->insert_id();
         return TRUE;
      }
      return FALSE;
   }

   public function Update_Data($table, $data, $where) {
      if ($where) {
         $this->db->where($where);
      }
      if ($this->db->update($table, $data)) {
         return TRUE;
      }
      return FALSE;
   }

   public function View_Data($table, $sel, $where, $order, $limit) {
      if ($where) {
         $this->db->where($where);
      }
      $this->db->select($sel);
      $this->db->from($table);
      if ($order) {
         $this->db->order_by($order[0], $order[1]);
      }
      if ($limit) {
         $this->db->limit($limit[0], $limit[1]);
      }
      return $this->db->get()->result();
   }

   public function View_Data_Two_Table($table1, $table2, $sel, $rel, $where, $order, $limit) {
      if ($where) {
         $this->db->where($where);
      }
      $this->db->select($sel);
      $this->db->from($table1);
      $this->db->join($table2, $rel);
      if ($order) {
         $this->db->order_by($order[0], $order[1]);
      }
      if ($limit) {
         $this->db->limit($limit[0], $limit[1]);
      }
      return $this->db->get()->result();
   }

   /*
      SELECT news.id, news.title, menu.ename, news.img_url, news.pic_name, news.picture, news.menuid, menu.name, news.menu_position, news.news_source, news.datetime FROM news, menu WHERE news.menuid = menu.id AND (menu.id=31 or menu.id=39 or menu.id=52 or menu.id=53 or menu.id=54) ORDER by news.id DESC LIMIT 12;
      */

      public function bangladesh_pages_news($limit) {
         $this->db->or_where("menu.id", 31);
         $this->db->or_where("menu.id", 39);
         $this->db->or_where("menu.id", 52);
         $this->db->or_where("menu.id", 53);
         $this->db->or_where("menu.id", 54);


         $this->db->select("news.id, news.title, menu.ename, news.img_url, news.pic_name, news.picture, news.menuid, menu.name, news.menu_position, news.news_source, news.datetime");
         $this->db->from("news");
         $this->db->join("menu", "news.menuid = menu.id");
         $this->db->order_by("news.id", "desc");
         if ($limit) {
            $this->db->limit($limit[0], $limit[1]);
         }
         return $this->db->get()->result();
      }

      public function opinion_pages_news($limit) {
         $this->db->or_where("menu.id", 45);
         $this->db->or_where("menu.id", 51);


         $this->db->select("news.id, news.title, menu.ename, news.img_url, news.pic_name, news.picture, news.menuid, menu.name, news.menu_position, news.news_source, news.datetime");
         $this->db->from("news");
         $this->db->join("menu", "news.menuid = menu.id");
         $this->db->order_by("news.id", "desc");
         if ($limit) {
            $this->db->limit($limit[0], $limit[1]);
         }
         return $this->db->get()->result();
      }

      public function Delete_Data($table, $where) {
         $this->db->where($where);
         $this->db->delete($table);
         if ($this->db->affected_rows()) {
            return TRUE;
         }
         return FALSE;
      }

      public function news_archive($date, $limit) {
         $this->db->like("news.datetime", $date);

         $this->db->select("news.id, news.title, menu.ename, news.img_url, news.pic_name, news.picture, news.menuid, menu.name, news.menu_position, news.news_source, news.datetime");
         $this->db->from("news");
         $this->db->join("menu", "news.menuid = menu.id");
         $this->db->order_by("news.id", "desc");
         if ($limit) {
            $this->db->limit($limit[0], $limit[1]);
         }
         return $this->db->get()->result();
      }

      public function news_search($date, $limit) {
         $this->db->like("news.title", $date);
         $this->db->select("news.id, news.title, menu.ename, news.img_url, news.pic_name, news.picture, news.menuid, menu.name, news.menu_position, news.news_source, news.datetime");
         $this->db->from("news");
         $this->db->join("menu", "news.menuid = menu.id");
         $this->db->order_by("news.id", "desc");
         if ($limit) {
            $this->db->limit($limit[0], $limit[1]);
         }
         return $this->db->get()->result();
      }

      public function TotalData($table, $where) {        
         $this->db->select("id");
         $this->db->from($table);
         if($where){
            $this->db->like($where[0], $where[1]);
         }         
         return $this->db->count_all_results();
      }

      public function home() {
         return $this->GetMultipleQueryResult("CALL home()");
      }

      public function category($id) {
         return $this->GetMultipleQueryResult("CALL category($id)");
      }

      public function bangladesh() {
         return $this->GetMultipleQueryResult("CALL bangladesh()");
      }

      public function sompadokio() {
         return $this->GetMultipleQueryResult("CALL sompadokio()");
      }

      public function category_pages($id) {
         return $this->GetMultipleQueryResult("CALL category_pages($id)");
      }

      public function bangladesh_pages() {
         return $this->GetMultipleQueryResult("CALL bangladesh_pages()");
      }

      public function opinion_pages() {
         return $this->GetMultipleQueryResult("CALL opinion_pages()");
      }

      public function articles($id) {
         return $this->GetMultipleQueryResult("CALL articles($id)");
      }

      public function archive() {
         return $this->GetMultipleQueryResult("CALL archives()");
      }

      public function search() {
         return $this->GetMultipleQueryResult("CALL search_data()");
      }

      public function vote() {
         return $this->GetMultipleQueryResult("CALL vote()");
      }

      public function archive_search($date, $start, $limit) {
         $this->db->where("news.datetime >=", "{$date} 00:00:00");
         $this->db->where("news.datetime <=", "{$date} 23:59:59");
         $this->db->select("news.id, news.title, menu.ename, news.picture, news.pic_name, datetime");
         $this->db->from("news");
         $this->db->join("menu", "news.menuid=menu.id");  
         $this->db->order_by("news.id", "desc");      
         $this->db->limit($limit, $start);
         return $this->db->get()->result();
      }
      public function total_archive($date) {

         $this->db->where("news.datetime >= ", "$date 00:00:00");
         $this->db->where("news.datetime <= ", "$date 23:59:59");
         $this->db->select("count(news.id)");
         $this->db->from("news"); 
         return $this->db->count_all_results();
      }

      public function search_title($title, $start, $limit) {
         $this->db->select("news.id, news.title, menu.ename, news.picture, news.pic_name, datetime");
         $this->db->from("news");
         $this->db->join("menu", "news.menuid=menu.id");      
         $this->db->like("news.title", $title);
         $this->db->order_by("news.id", "desc");      
         $this->db->limit($limit, $start);
         return $this->db->get()->result();
      }
      public function total_title($title) {
         $this->db->select("count(news.id)");
         $this->db->from("news"); 
         $this->db->like("news.title", $title);
         return $this->db->count_all_results();
      }

      public function GetMultipleQueryResult($queryString) {
         if (empty($queryString)) {
            return false;
         }
         $index = 0;
         $ResultSet = array();
         if (mysqli_multi_query($this->db->conn_id, $queryString)) {
            do {
               if (false != $result = mysqli_store_result($this->db->conn_id)) {
                  $rowID = 0;
                  while ($row = $result->fetch_object()) {
                     $ResultSet[$index][$rowID] = $row;
                     $rowID++;
                  }
               }
               $index++;
            } while (mysqli_more_results($this->db->conn_id) && mysqli_next_result($this->db->conn_id));
         }
         return $ResultSet;
      }

   }
