function htmlEncode(value){
  return $('<div/>').text(value).html();
}

function htmlDecode(value){    
  return $('<div/>').html(value).text();
}

function resetForm(selector) {
	$(selector).each(function(){
	        this.reset();	        	
	});
	$(selector+ " input[type=hidden]").val("");
	 
}

function populateForm(formselector,data,prefix) {
	if(prefix==undefined) { prefix = ""; }
	prefix = "#" + prefix + "_";
	$.each(data, function(name,value) {		 
	    $(prefix+name).val(value);
	});
} 

function popupWindow(pageURL, title,w,h) {
	var left = (screen.width/2)-(w/2);
	var top = (screen.height/2)-(h/2);
	window.open(pageURL, title, 'menubar=1, width='+w+', height='+h+', top='+top+', left='+left); 
} 

function formatDate(unixTimestamp) {
    var dt = new Date(unixTimestamp * 1000);
    var date = dt.getDate();
    var month = dt.getUTCMonth();
    var year = dt.getFullYear();    
    return date + "-" + month + "-" + year;
};

String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
};

function serverValidation(response){ 	
	if(response.authentication==true){	
	   
		if(response.authorization==true){
			if(response.error==false){					
				if(response.validation_status==true){					
					return true;
				}else{
					alert("Form validation failed.\nErrors :\n"+response.validation_errors);
					return false;
				}
			}else{
				alert(response.error);
				return false;	
			}
		}else{
			alert("You are unauthorized to perform this action");
			return false;
		}		 
	}else if(response.authentication==false){
		//Refresh the page to display login		 
		window.location = window.location.href;		
	}
}

function showError(textStatus, errorThrown){
	alert("Error : " + errorThrown + "\nStatus : " + textStatus);
}
