 


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
/*Table structure for table `epaper_categories` */

CREATE TABLE `epaper_categories` (
  `cat_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cat_title` varchar(255) NOT NULL DEFAULT '',
  `cat_alias` varchar(255) NOT NULL DEFAULT '',
  `cat_desc` varchar(1000) NOT NULL DEFAULT '',
  `cat_image` varchar(255) NOT NULL DEFAULT '',
  `cat_metadesc` varchar(1000) NOT NULL DEFAULT '',
  `cat_metakeys` varchar(1000) NOT NULL DEFAULT '',
  `cat_pid` int(11) unsigned NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `epaper_categories` */

insert  into `epaper_categories`(`cat_id`,`cat_title`,`cat_alias`,`cat_desc`,`cat_image`,`cat_metadesc`,`cat_metakeys`,`cat_pid`) values (1,'General ','genaral','','','','',0);

/*Table structure for table `epaper_editions` */

CREATE TABLE `epaper_editions` (
  `ed_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ed_title` varchar(255) NOT NULL DEFAULT '',
  `ed_alias` varchar(255) NOT NULL DEFAULT '',
  `ed_desc` varchar(1000) NOT NULL DEFAULT '',
  `ed_date` date NOT NULL,
  `ed_image` varchar(255) NOT NULL DEFAULT '',
  `ed_pdf` varchar(255) NOT NULL DEFAULT '',
  `ed_status` enum('public','private') NOT NULL,
  `ed_metadesc` varchar(1000) NOT NULL DEFAULT '',
  `ed_metakeys` varchar(1000) NOT NULL DEFAULT '',
  `cat_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`ed_id`),
  KEY `categories_editions` (`cat_id`),
  CONSTRAINT `categories_editions` FOREIGN KEY (`cat_id`) REFERENCES `epaper_categories` (`cat_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `epaper_editions` */

/*Table structure for table `epaper_featured_categories` */

CREATE TABLE `epaper_featured_categories` (
  `fcat_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fcat_order` int(11) unsigned NOT NULL,
  `cat_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`fcat_id`),
  KEY `Featured_Category` (`cat_id`),
  CONSTRAINT `Featured_Category` FOREIGN KEY (`cat_id`) REFERENCES `epaper_categories` (`cat_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `epaper_featured_categories` */

/*Table structure for table `epaper_featured_editions` */

CREATE TABLE `epaper_featured_editions` (
  `fed_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fed_order` int(11) unsigned NOT NULL,
  `ed_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`fed_id`),
  KEY `featured_editions` (`ed_id`),
  CONSTRAINT `featured_editions` FOREIGN KEY (`ed_id`) REFERENCES `epaper_editions` (`ed_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `epaper_featured_editions` */

/*Table structure for table `epaper_pages` */

CREATE TABLE `epaper_pages` (
  `pg_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pg_title` varchar(255) NOT NULL DEFAULT '',
  `pg_file` varchar(255) NOT NULL DEFAULT '',
  `pg_desc` varchar(1000) NOT NULL DEFAULT '',
  `pg_metadesc` varchar(1000) NOT NULL DEFAULT '',
  `pg_metakeys` varchar(1000) NOT NULL DEFAULT '',
  `pg_order` int(11) unsigned NOT NULL,
  `ed_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`pg_id`),
  KEY `editions_pages` (`ed_id`),
  CONSTRAINT `editions_pages` FOREIGN KEY (`ed_id`) REFERENCES `epaper_editions` (`ed_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `epaper_pages` */


/*Table structure for table `menus` */

CREATE TABLE `menus` (
  `m_id` int(11) NOT NULL AUTO_INCREMENT,
  `m_name` varchar(255) NOT NULL DEFAULT '',
  `m_place` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`m_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `menus` */

/*Table structure for table `menuitems` */

CREATE TABLE `menuitems` (
  `mitem_id` int(11) NOT NULL AUTO_INCREMENT,
  `mitem_title` varchar(255) NOT NULL DEFAULT '',
  `mitem_type` varchar(255) NOT NULL DEFAULT '',
  `mitem_order` int(11) NOT NULL,
  `mitem_target` enum('_blank','_self','_parent','_top') NOT NULL DEFAULT '_self',
  `mitem_data` text NOT NULL,
  `mitem_pid` int(11) NOT NULL,
  `m_id` int(11) NOT NULL,
  PRIMARY KEY (`mitem_id`),
  KEY `FK_menuitems` (`m_id`),
  CONSTRAINT `FK_menuitems` FOREIGN KEY (`m_id`) REFERENCES `menus` (`m_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `menuitems` */

/*Table structure for table `pages` */

CREATE TABLE `pages` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL DEFAULT '',
  `page_alias` varchar(255) NOT NULL DEFAULT '',
  `page_content` text NOT NULL,
  `page_metadesc` varchar(1000) NOT NULL DEFAULT '',
  `page_metakeys` varchar(1000) NOT NULL DEFAULT '',
  `page_status` enum('public','private') NOT NULL DEFAULT 'public',
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `pages` */

/*Table structure for table `qacaptcha_questions` */

CREATE TABLE `qacaptcha_questions` (
  `qa_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `qa_question` varchar(255) CHARACTER SET utf8 NOT NULL,
  `qa_answer` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `qa_casesensitive` tinyint(1) NOT NULL,
  PRIMARY KEY (`qa_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

/*Data for the table `qacaptcha_questions` */

insert  into `qacaptcha_questions`(`qa_id`,`qa_question`,`qa_answer`,`qa_casesensitive`) values (1,'2+2 = ?','4',0),(2,'4 x 3 = ?','12',0),(3,'85 - 5 = ?','80',0);

/*Table structure for table `settings` */

CREATE TABLE `settings` (
  `opt_class` varchar(255) NOT NULL,
  `opt_key` varchar(255) NOT NULL,
  `opt_value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `settings` */

insert  into `settings`(`opt_class`,`opt_key`,`opt_value`) values ('','admin_email','admin@example.com');

/*Table structure for table `slideshow` */

CREATE TABLE `slideshow` (
  `sl_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sl_title` varchar(255) NOT NULL DEFAULT '',
  `sl_desc` varchar(1000) NOT NULL DEFAULT '',
  `sl_image` varchar(255) NOT NULL DEFAULT '',
  `sl_link` varchar(1000) NOT NULL DEFAULT '',
  `sl_linktarget` enum('_blank','_self') NOT NULL DEFAULT '_self',
  `sl_order` int(11) unsigned NOT NULL,
  PRIMARY KEY (`sl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slideshow` */

/*Table structure for table `widgets` */

CREATE TABLE `widgets` (
  `wd_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wd_title` varchar(255) NOT NULL DEFAULT '',
  `wd_type` varchar(255) NOT NULL DEFAULT '',
  `wd_order` int(10) unsigned NOT NULL,
  `wd_data` text NOT NULL,
  `wd_panel` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`wd_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

 

ALTER TABLE `epaper_pages`   
  ADD COLUMN `pg_cdata` TEXT NOT NULL AFTER `pg_order`;

CREATE TABLE `epaper_maps`(  
  `mp_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `mp_title` VARCHAR(1000) NOT NULL,
  `mp_alias` VARCHAR(1000) NOT NULL,
  `mp_desc` TEXT NOT NULL,
  `mp_metakeys` VARCHAR(1000) NOT NULL,
  `mp_metadesc` VARCHAR(1000) NOT NULL,
  `mp_image` VARCHAR(255) NOT NULL,
  `mp_x` DECIMAL(10,4) NOT NULL,
  `mp_y` DECIMAL(10,4) NOT NULL,
  `mp_w` DECIMAL(10,4) NOT NULL,
  `mp_h` DECIMAL(10,4) NOT NULL,
  `mp_ratio` DECIMAL(10,4) NOT NULL,
  `pg_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`mp_id`),
  CONSTRAINT `FK_Pages_Maps` FOREIGN KEY (`pg_id`) REFERENCES `epaper_pages`(`pg_id`) ON UPDATE CASCADE ON DELETE CASCADE
);

-- 2.4

CREATE TABLE `users`(  
  `user_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_name` VARCHAR(255) NOT NULL,
  `user_email` VARCHAR(255) NOT NULL,
  `user_password` VARCHAR(255) NOT NULL,
  `user_status` ENUM('active','inactive') NOT NULL,
  `user_role` ENUM('admin','user') NOT NULL,
  `user_tasks` TEXT NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=INNODB CHARSET=utf8;

insert  into `users`(`user_id`,`user_name`,`user_email`,`user_password`,`user_status`,`user_role`,`user_tasks`) values (1,'admin','admin@example.com','1a1dc91c907325c69271ddf0c944bc72','active','admin','');

-- 2.5


ALTER TABLE `epaper_pages`   
  ADD COLUMN `pg_pdf` VARCHAR(255) NOT NULL DEFAULT '' AFTER `pg_cdata`;

ALTER TABLE `epaper_maps`   
  ADD COLUMN `mp_next_link` VARCHAR(255) NOT NULL DEFAULT '' AFTER `mp_ratio`;

DROP TABLE IF EXISTS `media`;
  
CREATE TABLE `media`( 
`md_id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT, 
`md_title` VARCHAR(255) NOT NULL, 
`md_file` VARCHAR(255) NOT NULL, PRIMARY KEY (`md_id`) ) 
ENGINE=INNODB CHARSET=utf8;

-- 2.6

CREATE TABLE `epaper_supps`(  
  `sp_id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sp_name` VARCHAR(255) NOT NULL,
  `sp_alias` VARCHAR(255) NOT NULL,
  `sp_order` INT(11) UNSIGNED NOT NULL,  
  `cat_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`sp_id`),
  CONSTRAINT `FK_cat_supp` FOREIGN KEY (`cat_id`) REFERENCES `epaper_categories`(`cat_id`) ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=INNODB CHARSET=utf8;

ALTER TABLE `epaper_pages`   
  ADD COLUMN `sp_id` INT(11) UNSIGNED NOT NULL AFTER `pg_pdf`;

CREATE TABLE `epaper_bookmarks`(  
  `bkm_id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bkm_title` VARCHAR(255) NOT NULL,
  `bkm_order` INT(11) UNSIGNED NOT NULL,
  `pg_id` INT(11) UNSIGNED NOT NULL,
  `ed_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`bkm_id`),
  CONSTRAINT `FK_Bkm_Pg` FOREIGN KEY (`pg_id`) REFERENCES `epaper_pages`(`pg_id`) ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=INNODB CHARSET=utf8;

-- 2.7

ALTER TABLE `epaper_maps`   
  CHANGE `mp_title` `mp_title` VARCHAR(1000) CHARSET utf8 NOT NULL,
  CHANGE `mp_alias` `mp_alias` VARCHAR(1000) CHARSET utf8 NOT NULL,
  CHANGE `mp_desc` `mp_desc` TEXT CHARSET utf8 NOT NULL,
  CHANGE `mp_metakeys` `mp_metakeys` VARCHAR(1000) CHARSET utf8 NOT NULL,
  CHANGE `mp_metadesc` `mp_metadesc` VARCHAR(1000) CHARSET utf8 NOT NULL,
  CHANGE `mp_image` `mp_image` VARCHAR(255) CHARSET utf8 NOT NULL,
  CHANGE `mp_next_link` `mp_next_link` VARCHAR(255) CHARSET utf8 DEFAULT ''  NOT NULL;

ALTER TABLE `epaper_bookmarks`   
  CHANGE `bkm_title` `bkm_title` VARCHAR(255) CHARSET utf8 NOT NULL;
 

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
