<?php

/*
  Application Developed By Abhinav Software
  Website: http://abhinavsoftware.com
  Email: contact@abhinavsoftware.com
  Developer: Ankur Gupta (ankurgupta555@gmail.com)
  Copyright Ankur Gupta

  For licensing and terms of use please read license.txt file
 */

/**
 * Base class of all controllers of Admin area
 */
class AdminController extends Controller {

    

    public function __construct($id = null, $module = null) {

        $this->init();  
        parent::__construct($id, $module);
        $this->requireLoggedIn();
         
        
        $tasks = array(
            "sys_manage_menus",
            "sys_manage_panels",
            "sys_manage_users",
            "sys_manage_captcha",
            "sys_change_settings",
        );
        TaskComponent::i()->addTask("System",$tasks[0],"Manage Menus");
        TaskComponent::i()->addTask("System",$tasks[1],"Manage Panels and Widgets");
        TaskComponent::i()->addTask("System",$tasks[2],"Manage Users");
        TaskComponent::i()->addTask("System",$tasks[3],"Manage Captcha Questions");
        TaskComponent::i()->addTask("System",$tasks[4],"Change Settings");
        if(License::i()->license==License::PERSONAL){
            TaskComponent::i()->addTask("System","sys_view_about","View About");
        }
        
        AdminMenu::i()->addMenuItem("system", "System", "#",$tasks);
        AdminMenu::i()->addSubMenuItem("system", "menus", "Menus", $this->createUrl("//admin/menu/index"),$tasks[0]);
        AdminMenu::i()->addSubMenuItem("system", "panels", "Panels &amp; Widgets", $this->createUrl("//admin/panel/index"),$tasks[1]);
        AdminMenu::i()->addSubMenuItem("system", "user", "Users", $this->createUrl("//admin/user/index"),$tasks[2]);
        AdminMenu::i()->addSubMenuItem("system", "captcha", "Q&amp;A Captcha", $this->createUrl("//admin/qacaptcha/index"),$tasks[3]);
        AdminMenu::i()->addSubMenuItem("system", "settings", "Settings", $this->createUrl("//admin/default/settings"),$tasks[4]);
        
        if(License::i()->license==License::PERSONAL){
            AdminMenu::i()->addSubMenuItem("system", "about", "About", $this->createUrl("//admin/default/about"),"sys_view_about");
        }
        
        $this->layout = "//layouts/admin_template";
        $this->perpage = 12;
    }

    /**
     * Keeps the session on on using file uploads etc...
     */
    function init() {
 

        if (isset($_POST['PHPSESSID'])) {
            $session = Yii::app()->getSession();
            $session->close();
            $session->sessionID = $_POST['PHPSESSID'];
            $session->open();
        }
    }

    private $_perpage;

    public function getPerpage() {
        return $this->_perpage;
    }

    public function setPerpage($value) {
        $this->_perpage = $value;
    }

}
