<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/


class AdminHelpers extends AbstractSinglaton{
 
    
    /** @var AdminHelpers::SIZE_XTRASMALL|AdminHelpers::SIZE_SMALL|AdminHelpers::SIZE_MEDIUM|AdminHelpers::SIZE_LARGE Size of buttons */
    public $size = AdminHelpers::SIZE_XTRASMALL;
    
    const SIZE_XTRASMALL = "btn-xs";
    const SIZE_SMALL = "btn-sm";
    const SIZE_MEDIUM = "btn-md";
    const SIZE_LARGE = "btn-lg";

    /**
     * Displays the Edit button link
     * @param integer $idvalue
     * @param string $href (optional)
     * @param string $class CSS Class (optional)
     * @return string HTML Anchor tag
     */
    public function linkbtnEdit($idvalue, $href = "#", $class = 'linkbtn_edit') {
     
        $icon = '<i class="glyphicon glyphicon-edit color-white"></i>';
        return CHtml::link($icon, $href, array("data-id" => $idvalue, "class" => $class." btn btn-success $this->size"));
    }

    /**
     * Displays the Delete button link
     * @param integer $idvalue
     * @param string $href (optional)
     * @param string $class CSS Class (optional)
     * @return string HTML Anchor tag
     */
    public function linkbtnDelete($idvalue, $href = "#", $class = 'linkbtn_delete') {
         
        $icon = '<i class="glyphicon glyphicon-trash color-white"></i>';
        return CHtml::link($icon, $href, array("data-id" => $idvalue, "class" => $class." btn btn-danger $this->size"));
    }

    /**
     * Displays the Move Up button link
     * @param integer $idvalue
     * @param string $href (optional)
     * @param string $class CSS Class (optional)
     * @return string HTML Anchor tag
     */
    public function linkbtnMoveUp($idvalue, $href = "#", $class = 'linkbtn_moveup') {
        
        $icon = '<i class="glyphicon glyphicon-arrow-up color-white"></i>';
        return CHtml::link($icon, $href, array("data-id" => $idvalue, "class" => $class." btn btn-primary $this->size"));
    }

    /**
     * Displays the Move Down button link
     * @param integer $idvalue
     * @param string $href (optional)
     * @param string $class CSS Class (optional)
     * @return string HTML Anchor tag
     */
    public function linkbtnMoveDown($idvalue, $href = "#", $class = 'linkbtn_movedown') {
         
        $icon = '<i class="glyphicon glyphicon-arrow-down color-white"></i>';
        return CHtml::link($icon, $href, array("data-id" => $idvalue, "class" => $class." btn btn-primary $this->size"));
    }
 
    /**
     * Displays the Open button link
     * @param integer $idvalue
     * @param string $href (optional)
     * @param string $class CSS Class (optional)
     * @return string HTML Anchor tag
     */
    public function linkbtnOpen($idvalue, $href = "#", $class = 'linkbtn_open') {
        $icon = '<i class="glyphicon glyphicon-folder-open color-white"></i>';
        return CHtml::link($icon, $href, array("data-id" => $idvalue, "class" => $class." btn btn-primary $this->size"));
    }

    /**
     * Displays the View button link
     * @param integer $idvalue
     * @param string $href (optional)
     * @param string $class CSS Class (optional)
     * @return string HTML Anchor tag
     */
    public function linkbtnView($idvalue, $href = "#", $class = 'linkbtn_view') {
        $icon = '<i class="glyphicon glyphicon-eye-open color-white"></i>';
        return CHtml::link($icon, $href, array("data-id" => $idvalue, "class" => $class." btn btn-primary $this->size"));
    }
}