<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

/**
 * AdminMenu class generates the menus in Admin Panel
 */
class AdminMenu extends AbstractSinglaton {

    /** @var array() */
    private $_topMenuItems = array();
    
    /** @var array() */
    private $_subMenuItems = array();

    /**
     * Adds a menuitem
     * @param integer $id Menuitem Id
     * @param string $title Title of Link
     * @param string $url Url of Link
     */
    public function addMenuItem($id, $title, $url, $task_id="") {
        $current_user_role = $this->_getIdentity()->user_role; 
        if($current_user_role=="admin"){
            $this->_topMenuItems[$id] = array("title" => $title, "url" => $url);
            return;
        }
        
        $user_tasks = unserialize($this->_getIdentity()->user_tasks); 
        if(!is_array($user_tasks)){
            $user_tasks = array();
        }
        if (!isset($_topMenuItems[$id])) {
            if(is_string($task_id)){
                if(in_array($task_id, $user_tasks)){
                    $this->_topMenuItems[$id] = array("title" => $title, "url" => $url);
                }
            } else  if(is_array($task_id)){
                foreach($task_id as $t){
                    if(in_array($t, $user_tasks)){
                        $this->_topMenuItems[$id] = array("title" => $title, "url" => $url);
                    }
                }
            }
        }
    }
    /**
     * Checks if a menuitem exists
     * @param integer $id Menuitem Id
     * @return boolean
     */
    public function hasMenuItem($id){
        return isset($this->_topMenuItems[$id]);
    }
    
    /**
     * Checks if a submenuitem exists
     * @param integer $pid
     * @param integer $id
     * @return boolean
     */
    public function hasSubMenuItem($pid,$id){
        return isset($this->_subMenuItems[$pid][$id]);
    }

    /**
     * Adds a submenu item inside a menu item
     * @param integer $pid Menu Item Id
     * @param integer $id Submenu Item Id
     * @param string $title Title of Link
     * @param string $url Url of Link
     */
    public function addSubMenuItem($pid, $id, $title, $url, $task_id="") {
         
        
        $current_user_role = $this->_getIdentity()->user_role; 
        if($current_user_role=="admin"){
             $this->_subMenuItems[$pid][$id] = array("title" => $title, "url" => $url);
             return;
        }
         
        $user_tasks = unserialize($this->_getIdentity()->user_tasks); 
        if(!is_array($user_tasks)){
            $user_tasks = array();
        }
        if (!isset($_subMenuItems[$pid][$id])) {            
            if(is_string($task_id)){
                if(in_array($task_id, $user_tasks)){
                    $this->_subMenuItems[$pid][$id] = array("title" => $title, "url" => $url);
                }
            } else  if(is_array($task_id)){
                foreach($task_id as $t){
                    if(in_array($t, $user_tasks)){
                        $this->_subMenuItems[$pid][$id] = array("title" => $title, "url" => $url);
                    }
                }
            } 
        }
    }
    private function _getIdentity(){
        $identity = Yii::app()->user->getState("identity");        
        if(!is_null($identity)){
            return $identity;
        }
        return new User();
    }
    /**
     * Renders the menu
     */
    public function render() {
        
        $topMenuItems = $this->_topMenuItems;
        $subMenuItems = $this->_subMenuItems;
         
        foreach ($topMenuItems as $tid => $tmi) {   
            if (isset($subMenuItems[$tid]) && count($subMenuItems[$tid]) > 0) {                 
                ?>
                <li class="dropdown">
                    <?php echo CHtml::link($tmi["title"]." <span class='caret'></span>", $tmi["url"], array("class"=>"dropdown-toggle","data-toggle"=>"dropdown")); ?>
                    <ul class="dropdown-menu">
                    <?php foreach ($subMenuItems[$tid] as $sid => $smi) { ?>
                        <li><?php echo CHtml::link($smi["title"], $smi["url"]); ?></li>
                    <?php } ?>     
                    </ul>
                </li>
            <?php } else { ?>
                <li><?php echo CHtml::link($tmi["title"], $tmi["url"]); ?></li>
            <?php
            }
        }
    }

}
