<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class AdminSettings extends AbstractSinglaton{
    /** @var array */    
    private $_tabs;
    
    /** @var array */    
    private $_forms;
    
    /**
     * Adds a tab/page in settings form in admin panel.
     * @param integer $id Tab Id
     * @param string $title Title
     */
    public function addTab($id,$title){
        if(!isset($this->_tabs[$id])){
            $this->_tabs[$id] = $title;
        }
    }
    
    /**
     * Adds a form in a setting tab/page
     * @param integer $tab_id Tab Id
     * @param integer $id Form Id
     * @param string $title Title 
     * @param string $class Settings class name
     */
    public function addForm($tab_id,$id,$title,$class){
        if(!isset($this->_forms[$tab_id][$id])){
            $this->_forms[$tab_id][$id] = array("title"=>$title,"class"=>$class);
        }
    }
    /**
     * Checks if tab exists
     * @param integer $id
     * @return boolean
     */
    public function hasTab($id){
        if(isset($this->_tabs[$id])){
            return true;
        }
        return false;
    }
    
    /**
     * Returns all the tabs
     * @return array
     */
    public function getTabs(){        
        return $this->_tabs;
    }
    
    /**
     * Get list of forms for given Tab Id
     * @param integer $tab_id
     * @return array
     */
    public function getFormsByTabId($tab_id){
        
        if(isset($this->_forms[$tab_id])){
            return $this->_forms[$tab_id];
        }
    }
}