<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * Ajax Output class outputs the data in json format
 */
class AjaxOutput extends AbstractSinglaton{
    
    private $_authenticaton;
    private $_authorization;
    private $_status;
    private $_validation_status;
    private $_validation_errors;
    private $_data;
    private $_error;

    /**
     * Returns the instance of AjaxOutput
     * @staticvar null $instance
     * @return \static
     */
    public static function i(){
        static $instance = null;
        if (null === $instance) {            
            $instance = new static();            
            
            $instance->_authenticaton = true;
            $instance->_authorization = true;
            $instance->_validation_status = true;
            $instance->_validation_errors = false;
            $instance->_status = false;
            $instance->_data = false;
            $instance->_error = false; 
        }
        return $instance;
    }
    /**
     * Sets the authentication true or false
     * @param boolean $authentication
     * @return \AjaxOutput
     */
    public function setAuthentication($authentication) {
        $this->_authenticaton = $authentication;
        return $this;
    }
    /**
     * Sets the authorization true or false
     * @param type $authorization
     * @return \AjaxOutput
     */
    public function setAuthorization($authorization) {
        $this->_authorization = $authorization;
        return $this;
    }

    /**
     * Sets the status true or false
     * @param type $status
     * @return \AjaxOutput
     */
    public function setStatus($status) {
        $this->_status = $status;
        return $this;
    }

    /**
     * Sets the validation status true or false (Should be used in form validation)
     * @param type $validation_status
     * @return \AjaxOutput
     */
    public function setValidationStatus($validation_status) {
        $this->_validation_status = $validation_status;
        return $this;
    }

    /**
     * Sets the validation errors in array (Should be used in form validation)
     * @param array $validation_errors
     * @return \AjaxOutput
     */
    public function setValidationErrors($validation_errors) {
        $this->_validation_errors = $validation_errors;
        return $this;
    }

    
    /**
     * Sets the data if it has multiple records
     * @param mixed $records
     * @param integer $total
     * @param mixed $report
     * @return \AjaxOutput
     */
    public function setDataArray($records = null, $total = null, $report = null) {
        $this->_data = array("records" => $records, "total" => $total, "report" => $report);
        return $this;
    }

    /**
     * Sets the data if it has single records
     * @param mixed $result
     * @param mixed $report
     * @return \AjaxOutput
     */
    public function setData($result = null, $report = null) {
        $this->_data = array("result" => $result, "report" => $report);
        return $this;
    }

    /**
     * Sets the error
     * @param string $error
     * @return \AjaxOutput
     */
    public function setError($error) {
        $this->_error = $error;
        return $this;
    }
    
    /**
     * Returns  the authentication status
     * @return boolean
     */
    public function getAuthentication() {
        return $this->_authentication;
        
    }

    /**
     * Returns  the authorization status
     * @return boolean
     */
    public function getAuthorization() {
        return $this->_authorization;
       
    }

    /**
     * Returns  the status
     * @return boolean
     */
    public function getStatus() {
        return $this->_status;
        
    }

    /**
     * Returns  the validation status
     * @return boolean
     */
    public function getValidationStatus() {
        return $this->_validation_status;
        
    }

    /**
     * Returns  the validation errors
     * @return array
     */
    public function getValidationErrors() {
        return $this->_validation_errors;
        
    }
    
    
    /**
     * Returns the data
     * @return boolean
     */
    public function getData() {
        return $this->_data;
        
    }

    /**
     * Gets the error
     * @return boolean
     */
    public function getError() {
        return $this->_error;
         
    }

    /**
     * Outputs the result in json format
     */
    public function display() {
        $data = array(
            "authentication" => $this->_authenticaton,
            "authorization" => $this->_authorization,
            "status" => $this->_status,
            "data" => $this->_data,
            "validation_status" => $this->_validation_status,
            "validation_errors" => $this->errorsToString($this->_validation_errors),
            "error" => $this->_error
        );
        echo CJavaScript::jsonEncode($data);
        exit();
    }
    
    /**
     * Converts validation errors array into string
     * @param array $errors
     * @return string
     */
    public function errorsToString($errors) {
        $str = "";
        if (is_array($errors)) {
            foreach ($errors as $element => $e) {
                $str .= implode("\n", $e) . "\n";
            }
        }
        return $str;
    }

}