<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

/**
 * Assets Manager class manages assets (e.g. CSS, JS and Image files folders)
 */
class AssetsManager extends AbstractSinglaton{
    private $_coreAsset;
    
    /**
     * Returns the file url of core asset file
     * @param string $filename
     * @return string
     */
    public function getCoreAsset($filename) {
        if (!isset($this->_coreAsset[$filename])) {             
            $assetsPath = Yii::getPathOfAlias('application.coreassets');               
            $assetsUrl = Yii::app()->getAssetManager()->publish($assetsPath);
            $fileUrl = $assetsUrl."/".$filename;            
            if(!is_null(Yii::app()->theme)){
                $theme_assetsPath = Yii::app()->theme->basePath."/assets/coreassets";                
                $theme_filePath = $theme_assetsPath."/".$filename;                
                $theme_assetsUrl = Yii::app()->theme->baseUrl."/assets/coreassets";
                $theme_fileUrl = $theme_assetsUrl."/".$filename;
                if(file_exists($theme_filePath)){
                    $fileUrl = $theme_fileUrl;                    
                }
            }   
            $this->_coreAsset[$filename] = $fileUrl;
        }
        return $this->_coreAsset[$filename]; 
    }
    
    private $_moduleAsset;
    
    /**
     * Returns the file url of specific module asset
     * @param string $modulename
     * @param string $filename
     * @return string
     */
    public function getModuleAsset($modulename,$filename) {
        if (!isset($this->_moduleAsset[$modulename][$filename])) {             
            $assetsPath = Yii::getPathOfAlias("application.modules.$modulename.assets");
            $assetsUrl = Yii::app()->getAssetManager()->publish($assetsPath);
            $fileUrl = $assetsUrl."/".$filename;
            if(!is_null(Yii::app()->theme)){
                $theme_assetsPath = Yii::app()->theme->basePath."/assets/".$modulename;                
                $theme_filePath = $theme_assetsPath."/".$filename;                
                $theme_assetsUrl = Yii::app()->theme->baseUrl."/assets/".$modulename;
                $theme_fileUrl = $theme_assetsUrl."/".$filename;
                if(file_exists($theme_filePath)){
                    $fileUrl = $theme_fileUrl;                    
                }
            }   
            $this->_moduleAsset[$modulename][$filename] = $fileUrl;
        }
        return $this->_moduleAsset[$modulename][$filename];
    }
}