<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

/**
 * Custom Breadcrumb class for displaying breadcrumbs
 */
class Breadcrumbs extends CBreadcrumbs {
    /** @var string */
    public $inactiveLastLink;
    /** @var string */
    public $activeLinkTemplate='<li><a href="{url}">{label}</a></li>';	
    /** @var string */
    public $inactiveLinkTemplate='<li class="active">{label}</li>';
    
    /**
     * Outputs the breadcrumb
     * @return string
     */
    public function run() {
        if (empty($this->links))
            return;

        echo CHtml::openTag($this->tagName, $this->htmlOptions) . "\n";
        $links = array();
        if ($this->homeLink === null)
            $links[] = CHtml::link("HOMEEE", Yii::app()->homeUrl);
        elseif ($this->homeLink !== false)
            $links[] = $this->homeLink;
        $i = 1;
        foreach ($this->links as $label => $url) {
            if(count($this->links)>$i){
                if (is_string($label) || is_array($url))
                    $links[] = strtr($this->activeLinkTemplate, array(
                        '{url}' => CHtml::normalizeUrl($url),
                        '{label}' => $this->encodeLabel ? CHtml::encode($label) : $label,
                    ));
                else
                    $links[] = str_replace('{label}', $this->encodeLabel ? CHtml::encode($url) : $url, $this->inactiveLinkTemplate);    
            } else {
                $links[] = str_replace('{label}', $this->encodeLabel ? CHtml::encode($label) : $url, $this->inactiveLinkTemplate);                     
            }
            $i++;
        }
        echo implode($this->separator, $links);
        echo CHtml::closeTag($this->tagName);
    }
}