<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

/**
 * Feed Component Class gathers the feeditems from all modules and generates the feed.
 */
class FeedComponent extends AbstractSinglaton{
    private $_items;
    
    /**
     * Add feed item 
     * @param string $title
     * @param string $description
     * @param string $link
     * @param integer $date
     * @param array $tags
     */
    public function addItem($title,$description,$link,$date,$tags = array()){
        $this->_items[$date] = array(
            "title"=>$title,
            "description"=>$description,
            "link"=>$link,
            "date"=>$date,
            "tags"=>$tags
        );
    }
    
    /**
     * Generates the feed
     */
    public function generate(){
        Yii::import("ext.feed.*");
          
        $feed = new EFeed();        
        $feed->title= FeedSettings::i()->feed_title;
        $feed->description = FeedSettings::i()->feed_description;       
        $feed->addChannelTag('language', FeedSettings::i()->feed_lang);
        $feed->addChannelTag('pubDate', date(DATE_RSS, strtotime(FeedSettings::i()->feed_pubdate)));
        $feed->addChannelTag('link', Yii::app()->createAbsoluteUrl("main/rss"));            
        $this->onGeneratingFeed(new CEvent($this,array("feed"=>$feed))); 
        
        
        if(count($this->_items)>0){
            krsort($this->_items);
            foreach ($this->_items as $date=>$item){                
                $feeditem = $feed->createNewItem(); 
                $feeditem->setTitle($item["title"]);
                $feeditem->setDescription($item["description"]);
                $feeditem->setLink($item["link"]);
                $feeditem->setDate($item["date"]);
                $feeditem->addTag('guid', $item["link"],array('isPermaLink'=>'true'));                
                if(count($item["tags"])>0){
                    foreach($item["tags"] as $k=>$v){
                        $feeditem->addTag($k, $v);
                    }
                }
                $feed->addItem($feeditem);
            }
        }
        
        $feed->generateFeed();
    }
    /**
     * Event to add feed items from modules
     * @param CEvent $event
     */
    public function onGeneratingFeed(CEvent $event){
        $this->raiseEvent("onGeneratingFeed", $event);
    }
}
