<?php
/**
 * HeadComponent class for generating page title, meta description and meta keywords tags
 */
class HeadComponent extends AbstractSinglaton{
    
    /** @var string Seperator for Meta Descriptions */
    public $sepMetaDesc = ". ";
    
    /** @var string Seperator for Meta Keywords */
    public $sepMetaKeys = ", ";
    
    /** @var string Seperator for Page Title */
    public $sepTitle = " - ";
    
    private $_metaDescriptions = array();
    private $_metaKeywords = array();
    private $_titles = array();
    
    private $_image = "";
    
    /**
     * Adds/Appends the meta description.
     * @param string $image
     * @return \HeadComponent
     */
    public function setImage($image){
        if(trim($image)!=""){            
            $this->_image = $image;
        }
        return $this;
    }
    
    /**
     * Sets the meta description. This will clear the previous meta descriptions
     * @param string $description
     * @return \HeadComponent
     */
    public function setMetaDescription($description){
        if(trim($description)!=""){
            $this->_metaDescriptions = array();
            $this->_metaDescriptions[] = $description;
        }
        return $this;
    }
    /**
     * Adds/Appends the meta description.
     * @param string $description
     * @return \HeadComponent
     */
    public function addMetaDescription($description){
        if(trim($description)!=""){            
            $this->_metaDescriptions[] = $description;
        }
        return $this;
    }
    
    /**
     * Sets the meta keywords. This will clear the previous meta keywords
     * @param string $keywords (Seperated by comma)
     * @return \HeadComponent
     */
    public function setMetaKeywords($keywords){
        $key_array = explode(",", trim($keywords));
        if(count($key_array)>0){
            $this->_metaKeywords = array();
            foreach($key_array as $key){
                if(trim($key)!=""){
                    $this->_metaKeywords[] = $key;
                }
            }
        }
        
        return $this;
    }
    
    /**
     * Adds/Appends the meta keywords.
     * @param string $keywords (Seperated by comma)
     * @return \HeadComponent
     */
    public function addMetaKeywords($keywords){
        $key_array = explode(",", trim($keywords));
        if(count($key_array)){
            foreach($key_array as $key){
                if(trim($key)!=""){
                    $this->_metaKeywords[] = $key;
                }
            }
        }
        return $this;
    }
    
    /**
     * Sets the page title. This will clear the previous entries of titles
     * @param string $title 
     * @return \HeadComponent
     */
    public function setTitle($title){
        if(trim($title)!=""){
            $this->_titles = array();
            $this->_titles[] = $title;
        }
        return $this;
    }
    
    /**
     * Adds/Appends the page title.
     * @param string $title 
     * @return \HeadComponent
     */
    public function addTitle($title){
        if(trim($title)!=""){
            $this->_titles[] = $title;
        }
        return $this;
    }
    
    /**
     * Generates the Page Title
     * @return string
     */
    public function generateTitle(){
        krsort($this->_titles);         
        return implode($this->sepTitle,$this->_titles);
    }
    
    /**
     * Generates the Meta Description
     * @return string
     */
    public function generateMetaDescription(){
        krsort($this->_metaDescriptions);         
        return implode($this->sepMetaDesc,$this->_metaDescriptions);
    }
    
    /**
     * Generates the Meta Keywords
     * @return string
     */
    public function generateMetaKeywords(){
        krsort($this->_metaKeywords);         
        return implode($this->sepMetaKeys,$this->_metaKeywords);
    }
    
    /**
     * Applies the tags in page. Should be run on before render method of CController class.
     */
    public function run(){
         Yii::app()->getClientScript()->registerMetaTag($this->generateMetaDescription(), 'description');
         Yii::app()->getClientScript()->registerMetaTag($this->generateMetaKeywords(), 'keywords');
         Yii::app()->getController()->setPageTitle($this->generateTitle());                  
         
         Yii::app()->getClientScript()->registerMetaTag($this->generateTitle(), 'og:title');
         Yii::app()->getClientScript()->registerMetaTag(Helpers::i()->currentPageURL(), 'og:url');
         Yii::app()->getClientScript()->registerMetaTag(BasicSettings::i()->site_title, 'og:site_name');         
         Yii::app()->getClientScript()->registerMetaTag($this->generateMetaDescription(), 'og:description');                  
         if(trim($this->_image) != ""){
            Yii::app()->getClientScript()->registerMetaTag($this->_image, 'og:image');         
         }
    }
}