<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

/**
 * ImageHelper class provides various methods to display/resize images on the fly
 */
class ImageHelpers extends AbstractSinglaton{
    /**
     * Returns the url of default image in square size
     * @param int $size
     * @return string
     */
    public function getDefaultImageSq($size) {
        
        $imageurl = AssetsManager::i()->getCoreAsset("images/default.jpg");
        return Yii::app()->createAbsoluteUrl("//image/index", array("image" => $imageurl, "width" => $size, "height" => $size, "cropratio" => "1:1"));
    }
    
    /**
     * Returns the default image url
     * @param integer $width
     * @param integer|null $height
     * @param boolean $crop
     * @return string
     */
    public function getDefaultImage($width,$height=null,$crop=false) {
        
        $imageurl = AssetsManager::i()->getCoreAsset("images/default.jpg");
        return $this->getThumbImage($imageurl, $width, $height, $crop);
    }
    
    /**
     * Returns the url of resized version of image
     * @param string $imageurl
     * @param integer $width
     * @param integer $height
     * @param boolean $crop
     * @return string
     */
    public function getThumbImage($imageurl, $width, $height = null,$crop=false) {
        
        if($crop==false){
            if ($height == null) {
                return Yii::app()->createAbsoluteUrl("//image/index", array("image" => $imageurl, "width" => $width));
            } else {
                return Yii::app()->createAbsoluteUrl("//image/index", array("image" => $imageurl, "width" => $width, "height" => $height));
            }
        } else {
            if ($height == null) {
                return Yii::app()->createAbsoluteUrl("//image/index", array("image" => $imageurl, "width" => $width));
            } else {
                
                $ratio = Helpers::i()->getRatio($width, $height);
               
                return Yii::app()->createAbsoluteUrl("//image/index", array("image" => $imageurl, "width" => $width, "height" => $height,"cropratio"=>"$ratio[0]:$ratio[1]"));
            }
        }
    }

    /**
     * Returns url of square sized version of image
     * @param string $imageurl
     * @param int $size
     * @return string
     */
    public function getThumbImageSq($imageurl, $size) {       
        return Yii::app()->createAbsoluteUrl("//image/index", array("image" => $imageurl, "width" => $size, "height" => $size, "cropratio" => "1:1"));
    }
 
     
}