<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

class License{
    const PERSONAL = "persoanl";
    const DEVELOPER = "developer";
    
    private $_config;
    
    public static function i(){
        static $instance = null;
        if (null === $instance) {            
            $instance = new static();    
            $instance->_loadConfig();
        }
        return $instance;
    }
    
    public $license;
    
    private function _loadConfig(){
        $this->license = self::PERSONAL;
        $file = Yii::getPathOfAlias("application.config")."/developer.php";
        if(file_exists($file)){
            $this->license = self::DEVELOPER;
            $this->_config = require_once($file);
        }
    }
    
    public function getAdminLogo(){
        if(isset($this->_config["logo_url"])){
            return $this->_config["logo_url"];
        }  
        return AssetsManager::i()->getCoreAsset("images/logo.png");         
    }
    
    public function getAdminCredit(){
        if(isset($this->_config["admin_credit"])){
            return $this->_config["admin_credit"];
        }  
        return 'Epaper CMS '.Yii::app()->controller->version.' Developed By <a href="http://abhinavsoftware.com" target="_blank">Abhinav Software</a>'; 
    }
    
    public function getPublicCredit(){
        if(isset($this->_config["public_credit"])){
            return $this->_config["public_credit"];
        }  
        return 'Website Powered By <a href="http://abhinavsoftware.com" target="_blank">Abhinav Software</a> Epaper CMS'; 
    }
    
    public function getDashboardText(){
        if(isset($this->_config["dashboard_text"])){
            return $this->_config["dashboard_text"];
        }
        return "";
    }
    
    protected function __construct() { }    
    
    
}