<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/


class MediaManager extends AbstractSinglaton{
    
    private $_folder = "";
    public function setFolder($folder){
        $this->_folder = $folder;
        return $this;
    }
    
    public function upload($uploadedFile, $existingFile=""){
        if(is_null($uploadedFile)){
            return $existingFile;
        }
        
        
        $baseDir = Yii::getPathOfAlias("webroot");
        $uploadDir = Yii::app()->params["uploadDir"];
        
        $monthDir = date("Y-m")."/";
        
        if(!file_exists($baseDir.$uploadDir)){
            mkdir($baseDir.$uploadDir);                   
        }
        if(!file_exists($baseDir.$uploadDir.$this->_folder)){
            mkdir($baseDir.$uploadDir.$this->_folder);
        }
        if(!file_exists($baseDir.$uploadDir.$this->_folder.$monthDir)){
            mkdir($baseDir.$uploadDir.$this->_folder.$monthDir);
        }
        
        $filename = $monthDir.uniqid().".".$uploadedFile->getExtensionName();
        $uploadedFile->saveAs($baseDir.$uploadDir.$this->_folder.$filename);
         
        return $filename; //it will include month too...
    }
    public function delete($filename){        
        $config = ModuleLoader::getConfig("epaper");        
        $baseDir = Yii::getPathOfAlias("webroot");
        $uploadDir = Yii::app()->params["uploadDir"];
        
        
        if(trim($filename)!==""){ 
            $uploadDir2 = $baseDir.$uploadDir.$this->_folder;
            if(file_exists($uploadDir2.$filename)){
                return unlink($uploadDir2.$filename);
            }
        }
        return false;        
    }
}