<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class MenuComponent extends AbstractSinglaton{
    private $_walkers;
    private $_placeholders;
    
    /**
     * Adds a menu placeholder
     * @param array $placeholder
     */
    public function addMenuPlaceholder($placeholder){
        /*
         * params $menu array(
         *      "id"=>"top-menu"
         *      "title"=>"Top Menu"
         *      "walker"=>"default"
         * )
         */
        $this->_placeholders[$placeholder["id"]] = $placeholder;
    }
    
    /**
     * Adds a menu walker
     * @param string $walker
     */
    public function addMenuWalker($walker){
        $this->_walkers[$walker] = $walker;
    }
    
    /**
     * Updates the menu cache in database
     */
    public function updateMenuCache(){
        Settings::i()->save("menucache", serialize($this->_loadMenuItems_Step1()));
    }
    
    /**
     * Loads the menuitems of specific placeholder
     * @param string $placeholder_id
     * @return string|array
     */
    public function loadMenuItems($placeholder_id){
        $cache = Settings::i()->get("menucache","");
        if($cache==""){
            $this->updateMenuCache();
            Settings::i()->init();
            $cache = Settings::i()->get("menucache","");
        }
        $data = unserialize($cache);
        
        foreach($data as $menu_id=>$r){
            if($r["placeholder"]==$placeholder_id){
                return $r["menuitems"];
            }
        }
        return "";
        
    }
    
    /**
     * Loads the menuitems of specific menu id
     * @param integer $menu_id
     * @return string
     */
    public function loadMenuitemsByMenuId($menu_id){
        $cache = Settings::i()->get("menucache","");
        if($cache==""){
            $this->updateMenuCache();
            Settings::i()->init();
            $cache = Settings::i()->get("menucache","");
        }
        $data = unserialize($cache);        
        if(isset($data[$menu_id])){
            return $data[$menu_id]["menuitems"];
        }
        return "";
    }
    private function _loadMenuItems_Step1() {
        $data = array();
        $menus = Menu::model()->findAll();
        if (count($menus)>0) {
            foreach ($menus as $menu) { 
                $menuitems = array();
                if (is_null($menu)) {
                    return false;
                }
                $m_id = $menu->m_id;
                $cri = new CDbCriteria();
                $cri->condition = "m_id = :m_id AND mitem_pid = 0";
                $cri->params = array(":m_id" => $m_id);
                $cri->order = "mitem_order ASC";
                $models = Menuitem::model()->findAll($cri);
                if (count($models) > 0) {
                    foreach ($models as $model) {
                        $menuitems[] = $this->_loadMenuItems_Step2($model);
                    }
                }
                $data[$menu->m_id]["placeholder"] = $menu->m_place;
                $data[$menu->m_id]["menuitems"] = $menuitems;
            }   
        }        
        return $data;
    }
    
    private function _loadMenuItems_Step2($model, $submenu = false) {
         
        $arg = array(
            "title" => $model->mitem_title,
            "order" => $model->mitem_order,
            "target" => $model->mitem_target,
            "type" => $model->mitem_type,
            "parent" => $model->mitem_pid,
            "menu_id" => $model->m_id
        );
        $classname = $model->mitem_type;
        $url = "";        
        if(class_exists($classname)){
            $obj = new $classname;
            $url = $obj->getLink($arg, unserialize($model->mitem_data));
            $children = array();
            $subs = $model->getRelated("rSubMenuitem");
            if (count($subs) > 0) {
                foreach ($subs as $sub) {
                    $children[] = $this->_loadMenuItems_Step2($sub, true);
                }
            }
        }
        return array(
                "title" => $model->mitem_title,
                "url" => $url,
                "target" => $model->mitem_target,
                "children" => $children
            );
    }
    /**
     * Renders the menu
     * @param string $placeholder_id
     * @return string
     */
    public function render($placeholder_id){
        $placeholder = NPlugins::i()->find("menu_placeholders", "id", $placeholder_id);
        if($placeholder !=false){            
            $walker = $placeholder["walker"];
            $walker_class = "DefaultMWalker";
            if(isset($this->_walkers[$walker])){
                $walker_class = $this->_walkers[$walker];                
            }   
            $menuitems = $this->loadMenuItems($placeholder_id);             
             
            return $walker_class::i()->walk($menuitems,$placeholder);            
        }
        return "";
    }
    
}