<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class ModuleLoader extends CApplicationComponent{
    private static $_isLoaded = false;
   
    private static $_homepages = array("main/index"=>"Default");
    
    private static $_config = array();
    
    private static $_modules = array();
    
    /**
     * @return array Array of modules
     */
    public static function listModules(){
        return self::$_modules;
    }
   
    /**
     * Returns array of registered homepages
     * @return array
     */
    public static function getHomePages(){
        return self::$_homepages;
    }
    
    /**
     * Returns the configuration data from {Module}Loader.php file
     * @param string $modulename
     * @return boolean|array
     */
    public static function getConfig($modulename){
        if(isset(self::$_config[$modulename])){
            return self::$_config[$modulename];
        }else{
            return false;
        }
    }
    
    /**
     * Loads all the modules
     * @param boolean $refresh
     */
    public static function loadModules($refresh=false){     
        if(!Yii::app()->user->isGuest){
            $model = User::model()->find("user_id = :user_id AND user_status = 'active'",array(":user_id"=>Yii::app()->user->Id));
            if(is_null($model)){
                Yii::app()->user->logout();
                Yii::app()->user->returnUrl = Yii::app()->request->getRequestUri();
                Yii::app()->request->redirect(Yii::app()->createUrl("//main/signin"));
            }
            Yii::app()->user->setState("identity",$model);
        }
        if(is_null(self::$_isLoaded) || $refresh==true){
            self::$_isLoaded = true;
            $modules_dir = Yii::getPathOfAlias("application.modules");
            $directories = scandir($modules_dir);
            $dirlist = array();
            foreach ($directories as $key => $module_name) {
             
                Yii::setPathOfAlias($module_name, Yii::app()->getModulePath()."/".$module_name);
                
                if (!in_array($module_name, array(".", ".."))) {
                    if (is_dir($modules_dir . "/" . $module_name)) {
                        self::$_modules[] = $module_name;
                        $module_directory = $modules_dir . "/" . $module_name;
                        $loader_file = $module_directory."/".ucfirst($module_name)."Loader.php";
                        if(file_exists($loader_file)){
                            
                            require_once $loader_file;
                            $loaderClass = ucfirst($module_name)."Loader";
                             
                            //Importing Classes
                            foreach($loaderClass::getImports() as $import){
                                Yii::import($import);
                            }
                            
                            //Load this configuration data
                            self::$_config[$module_name] = $loaderClass::getConfig();
                            
                            //Run init method
                            $loaderClass::init();
                            
                            //Loading Url Rewriting Rules
                            $urlmanager = Yii::app()->getUrlManager();
                            $routing = $loaderClass::getUrlRewritingRules();                            
                            if($routing["mode"]=="prepend"){
                                foreach($routing["rules"] as $request=>$route){
                                    $urlmanager->addRules(array($request=>$route),false);
                                }                                
                            } else if($routing["mode"]=="append") {
                                foreach($routing["rules"] as $request=>$route){
                                    $urlmanager->addRules(array($request=>$route),true);
                                }                                
                            }
                            
                            //Loading Homepage lists                            
                            self::$_homepages = self::$_homepages + $loaderClass::getHomePages();
                            $urlmanager->addRules(array(""=>BasicSettings::i()->homepage),false);                             
                        }  
                    }
                }
            }
        }
    }
    
    
    
     
}