<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class NPlugins extends AbstractSinglaton{
    private $_nplugins;
    
    /**
     * Returns all the registered NPlugins
     * @return array
     */
    public function get(){
        if(is_null($this->_nplugins)){       
            $this->init();
        }        
        return $this->_nplugins;
    }
    /**
     * Loads NPlugins from core, modules and active theme
     */
    public function init(){
             
            $types = array("menuitems","mwalker","settings","widgets","wtemplate");
            
            $np["menu_placeholders"] = array();             
            $np["widget_panels"] = array();            
            $np["setting_tabs"] = array();            
            $np["menuitems"] = array();
            $np["widgets"] = array();
            
            
            $findIndex = function ($collection,$key,$value){        
                $n=0;
                foreach($collection as $r){
                    if(isset($r[$key]) && $r[$key]==$value){
                        return $n;
                    }
                    $n++;
                }
                return count($collection);
            };
            
            
            
            $configLoader = function($config_file) use(&$np, $findIndex){
                
                if(file_exists($config_file)){                    
                    $config = require($config_file);
                    foreach($config as $k=>$v){                         
                        if($k=="widget_panels" || $k=="setting_tabs" || $k=="menu_placeholders"){
                            foreach($v as $vdata){
                                $index = $findIndex($np[$k], "id", $vdata["id"]);                                
                                $np[$k][$index] = $vdata;
                            }
                        } else {                            
                            $np[$k] = array_merge($np[$k],$v);
                        }
                    }
                    
                    
                }
            };
 
            //Load Default Plugins        
            foreach($types as $type){
                $alias = "application.nplugins.".$type;                
                if(file_exists(Yii::getPathOfAlias($alias))){       
                    Yii::import($alias.".*");            
                }
                
            }
            $config_file = Yii::getPathOfAlias("application.nplugins")."/config.php";
         
            $configLoader($config_file);
            

            //Load Module Plugins
            $modules_dir = Yii::getPathOfAlias("application.modules");
            $directories = scandir($modules_dir);        
            foreach ($directories as $key => $module_name) {
                if($module_name!="." && $module_name!=".."){
                    foreach($types as $type){
                        $alias = $module_name.".nplugins.".$type;
                        if(file_exists(Yii::getPathOfAlias($alias))){
                            Yii::import($alias.".*");            
                        }
                         
                    }
                    
                    
                    $config_file = Yii::getPathOfAlias("application.modules.$module_name.nplugins")."/config.php";                    
                    $configLoader($config_file);
                }
                
            }

            
            //Load Theme Plugins
            $theme = BasicSettings::i()->theme;
            if($theme!="none" && $theme!=false){
                foreach($types as $type){
                    $alias = "webroot.themes.$theme.nplugins.".$type;
                    if(file_exists(Yii::getPathOfAlias($alias))){
                        Yii::import($alias.".*");            
                    }    
                     
                     
                }
                $config_file = Yii::getPathOfAlias("webroot.themes.$theme.nplugins")."/config.php";
                $configLoader($config_file);
            }
        
            $this->_nplugins = $np;    
            
        
    }
    
    public function __get($key){
        if(isset($this->_nplugins[$key])){
            return $this->_nplugins[$key];
        }
        return $this->$key;
    }
    
    /**
     * Finds the value of specific nplugin
     * @param string $nplugin
     * @param string $key
     * @param mixed $value
     * @return boolean|mixed
     */
    public function find($nplugin,$key,$value){
        if(isset($this->_nplugins[$nplugin])){            
            foreach($this->_nplugins[$nplugin] as $r){
                if(isset($r[$key]) && $r[$key]==$value){
                    return $r;
                }                 
            }    
        }
        return false;
    }
    
    
}