<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PanelComponent extends AbstractSinglaton{
    /**
     * Renders the panel with widgets
     * @param string $panelname
     * @return boolean
     */
    public function render($panelname) {
        
        $panel = NPlugins::i()->find("widget_panels","id",$panelname);
        if($panel==false){
            return false;
        }
        $template_class = $panel["template"];        
        $widget_template = $template_class::i()->get();

        $cri = new CDbCriteria();
        $cri->condition = "wd_panel = :wd_panel";
        $cri->params = array(":wd_panel" => $panelname);
        $cri->order = "wd_order ASC";
        $models = Widget::model()->findAll($cri);
        $finalhtml = "";
        if (count($models) > 0) {
            foreach ($models as $model) {
                $arg = array(
                    "title" => $model->wd_title,
                    "order" => $model->wd_order,
                    "panel" => $model->wd_panel,
                    "type" => $model->wd_type
                );
                $classname = $model->wd_type;
                
                    $obj = new $classname;
                    $widgets = $obj->render($arg, unserialize($model->wd_data));
                    if (trim($model->wd_title) == "") {
                        $widgethtml = $widget_template["without_title"];
                    } else {
                        $widgethtml = $widget_template["with_title"];
                    }
                    foreach ($widgets as $placeholder => $data) {
                        $widgethtml = str_replace("{" . $placeholder . "}", $data, $widgethtml);
                    }
                    $finalhtml .= $widgethtml;
                 
                
            }
        }
        return $finalhtml;
    }
}