<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PublicController extends Controller {

    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        $this->layout = "//layouts/public_template";
        
         
        Yii::app()->setLanguage(BasicSettings::i()->language);
        
        if(BasicSettings::i()->theme!="none" && BasicSettings::i()->theme!=false){
            Yii::app()->theme = BasicSettings::i()->theme;
        }         
        HeadComponent::i()->addMetaDescription(BasicSettings::i()->site_description);
        HeadComponent::i()->addMetaKeywords(BasicSettings::i()->site_keywords);
        HeadComponent::i()->addTitle(BasicSettings::i()->site_title);
        
    } 
    
    /**
     * Runs before rendering the view and executes the run() method of HeadComponent
     * @param string $view
     * @return boolean
     */
    protected function beforeRender($view){ 
        HeadComponent::i()->run();
        return true;
    }
    
   
    /**
     * @var array
     */
    public $breadcrumbs = array();
     
    
}