<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

class QACaptcha {

    //Here we store the generated form key  
    private $_formKey;
    //Here we store the old form key (more info at step 4)  
    private $_oldFormKey;
    private $_keyname;
    
    
    /**
     * @param string $keyname
     */
    function __construct($keyname="") {
        //We need the previous key so we store it   
        
        $this->_keyname = $keyname;
        if (isset(Yii::app()->session[$this->_keyname.'_qid'])) {
            $this->_oldFormKey = Yii::app()->session[$this->_keyname.'_qid'];
        }
    }
    
    /**
     * Function to generate the form key  
     */    
    private function _generateKey() {        
        $question = QACaptchaQuestion::model()->getRandomQuestion();        
        if($question!==false){
            return $question["qid"];
        }
        return false;
    }

    /**
     * Returns the text field to enter the answer of captcha
     * @return string
     */
    public function outputKey() {
        //Generate the key and store it inside the class  
        $this->_formKey = $this->_generateKey();

        //Store the form key in the session  
        Yii::app()->session[$this->_keyname."_qid"] = $this->_formKey;
        //Output the form key          
        $model = QACaptchaQuestion::model()->findByPk($this->_formKey);        
        if(!is_null($model)){
            return $model->qa_question."<br />".CHtml::textField($this->_keyname."_qid");       
        } else {
            return CHtml::textField($this->_keyname."_qid");       
        }
         
     }
    /**
     * Validates the captcha
     * @return boolean
     */
    public function validate() {
        //We use the old formKey and not the new generated version  
        if(!isset($_POST[$this->_keyname.'_qid'])){
            return false;
        }
        $qid = $this->_oldFormKey;
        $answer_given = $_POST[$this->_keyname.'_qid'];
        
        return QACaptchaQuestion::model()->validateAnswer($qid, $answer_given);         
    }
    /**
     * Clears the captcha key
     */
    public function clearKey() {
        unset(Yii::app()->session[$this->_keyname.'_qid']);
    }

}

