<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class Settings extends AbstractSinglaton{
    /**
     * Returns the instance of class
     * @staticvar null $instance
     * @return \static
     */
    public static function i(){
        static $instance = null;
        if (null === $instance) {            
            $instance = new static();            
            $instance->init();
        }
        return $instance;
    }
    
    protected function __construct() { }

    private $_settings;
    
    /**
     * Initiates the settings
     * @return array
     */
    public function init(){
        $cmd = Yii::app()->db->createCommand();
        $result = $cmd->select("*")->from("settings")->queryAll();        
        if (count($result) > 0) {
            foreach ($result as $r) {
                $this->_settings[$r["opt_class"]][$r["opt_key"]] = $r["opt_value"];
            }
        }
        return $this->_settings;
    }
    
    /**
     * Returns the value of setting key. Returns false if not found
     * @param string $key
     * @param string $class
     * @return boolean|string
     */
    public function get($key,$class=""){        
        if(isset($this->_settings[$class][$key])){
            return $this->_settings[$class][$key];
        }
        return false;
    }
    
    /**
     * Returns the list of settings of specific class/category. Returns false if not found
     * @param string $class
     * @return boolean|array
     */
    public function getByClass($class=""){
        if(isset($this->_settings[$class])){
            return $this->_settings[$class];
        }
        return false;
    }
    
    /**
     * Saves the settings
     * @param string $key
     * @param mixed $value
     * @param string $class
     */
    public function save($key,$value,$class=""){
        
        $cmd = Yii::app()->db->createCommand();
        $result = $cmd->select("*")->from("settings")->where("opt_class = :opt_class AND opt_key = :opt_key", array(":opt_class"=>$class,":opt_key" => $key))->queryAll();

        $cmd = Yii::app()->db->createCommand();
        if (count($result) > 0) {
            $cmd->update("settings", array("opt_value" => $value), "opt_class = :opt_class AND opt_key = :opt_key", array(":opt_class"=>$class,":opt_key" => $key));
        } else {
            $cmd->insert("settings", array("opt_value" => $value, "opt_key" => $key, "opt_class"=>$class));
        }
    } 
    
    /**
     * Deletes the settings in the class
     * @param string $key
     * @param string $class
     */
    public function delete($key,$class=""){
        $cmd = Yii::app()->db->createCommand();
        $cmd->delete("settings", "opt_class = :opt_class AND opt_key = :opt_key", array(":opt_class"=>$class,":opt_key" => $key));
        
    }
}