<?php

class ShareItWidget extends CWidget{
    public $fontsize;
    public $title;
    public $link;
 
 
    public function init(){        
        $w = "16.6%";
        if (Yii::app()->mobileDetect->isMobile() || Yii::app()->mobileDetect->isTablet()) {
            $w = "14.2%";
        }
        $cs = Yii::app()->getClientScript();    
        $cs->registerCssFile(AssetsManager::i()->getCoreAsset("font-awesome/css/font-awesome.min.css"));
        $style = <<<EOF
                 
                .shareit_outer{
                    clear:both;
                    padding:5px;
                }
                .shareit{  
                    text-align:center;
                     
                    display:block;
                    float:left;
                    width:$w;
                    padding:3px;               
                    color:white;
                    font-size:$this->fontsize;
                }
                .shareit:hover, .shareit:focus, .shareit:active{
                    color:white;
                    opacity:0.9;
                    text-decoration:none;
                }
                .facebook{ background-color:#3B5B99; }
                .twitter{ background-color:#29A8E1; }
                .google{ background-color:#E14B36 }
                .linkedin{ background-color:#1979BB }
                .whatsapp{ background-color:#4BB34C }
                .print{ background-color:#E26900 }
                .email{ background-color:#E81A86 }
                
EOF;
        $cs->registerCss("shareit", $style);        
    }
    public function run(){
        return;
        $links = array(
            "facebook"=>array(
                "icon"=>"facebook",
                "link"=>"https://www.facebook.com/sharer/sharer.php?u={link}",
            ),
            "twitter"=>array(
                "icon"=>"twitter",
                "link"=>"https://twitter.com/home?status={title} {link}",
            ),
            "google"=>array(
                "icon"=>"google-plus",
                "link"=>"https://plus.google.com/share?url={link}",
            ),
            "linkedin"=>array(
                "icon"=>"linkedin",
                "link"=>"https://www.linkedin.com/shareArticle?mini=true&url={link}&title={title}&summary={title} - {link}&source=",
            ), 
            "print"=>array(
                "icon"=>"print",
                "link"=>"",
            ),
            "email"=>array(
                "icon"=>"envelope",
                "link"=>"",
            ),      
        );
        echo "<div class='shareit_outer clearfix'>";
        foreach($links as $name=>$p){
            if($name=="print"){
                ?>
                <a target="_blank" href="#" onclick="window.print(); return false;" class="shareit <?php echo $name; ?>">
                    <i class="fa fa-<?php echo $p["icon"]; ?>"></i>
                </a>
                <?php if (Yii::app()->mobileDetect->isMobile() || Yii::app()->mobileDetect->isTablet()) { ?>
                    <a target="_blank" href="whatsapp://send?text=<?php echo urlencode($this->title . " " . $this->link) ?>" class="shareit whatsapp">
                        <i class="fa fa-whatsapp"></i>
                    </a> 
                <?php } ?>

                <?php
            } else if($name=="email"){ 
                ?>
                <a target="_blank" href="mailto:?Subject=<?php echo $this->title; ?>&body=<?php echo $this->link ?>" class="shareit <?php echo $name; ?>">
                    <i class="fa fa-<?php echo $p["icon"]; ?>"></i>
                </a>
                <?php
            } else {
                $p["link"] = str_replace("{title}", $this->title, $p["link"]);
                $p["link"] = str_replace("{link}", $this->link, $p["link"]);
                ?>
                <a target="_blank" href="<?php echo $p["link"] ?>" class="shareit <?php echo $name; ?>">
                    <i class="fa fa-<?php echo $p["icon"]; ?>"></i> 
                </a>
                <?php
            }
        }
        echo "</div>";
    }
}