<?php

class SitemapGenerator{
    private $_items = array();
    public function addItem($id,$location,$frequency,$priority){        
        $this->_items[$id] = array(
            "location" => $location,
            "frequency" => $frequency,
            "priority" => $priority
        );
    }
    public function generateSitemap(){
        $str = "";
        if (count($this->_items) > 0) {
            $str = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
            foreach ($this->_items as $r) {
                $str .= "<url>";
                $str .= "<loc>" . $r["location"] . "</loc>";
                if (isset($r["priority"])) {
                    if(trim($r["priority"])!=""){
                        $str .= "<priority>" . $r["priority"] . "</priority>";
                    }
                }
                if (isset($r["frequency"])) {
                    if(trim($r["frequency"])!=""){
                        $str .= "<changefreq>" . $r["frequency"] . "</changefreq>";
                    }
                }
                $str .= "</url>";
            }
            $str .= '</urlset>';
        }
        
        return $str;
    }
    public function generateSitemapIndex(){
        $sitemapDir = Yii::app()->params["sitemapDir"];
        $str = '<?xml version="1.0" encoding="UTF-8"?>';
        $str .= '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        foreach (glob(Yii::getPathOfAlias("webroot").$sitemapDir."*.xml") as $filename){         
             $filename2= pathinfo($filename,PATHINFO_BASENAME); 
             $str .= "<sitemap>";
             $str .= "<loc>".Yii::app()->getBaseUrl(true).$sitemapDir.$filename2."</loc>";
             $str .= "</sitemap>";
        }
        $str .= '</sitemapindex>';
        return $str;
    }
         
    public static function make(){
         
        $gen = new SitemapGenerator();
        
  
        file_put_contents(Yii::getPathOfAlias("webroot")."/sitemap.xml", $gen->generateSitemapIndex());
    }
}