<?php

class TaskComponent extends AbstractSinglaton{
    private $tasks = array();
    public function listTasks(){
        return $this->tasks;
    }
    public function addTask($category,$task_id,$task_name){
        $this->tasks[$category][$task_id] = $task_name;        
    }
    public function checkPermissions($task_id){
        if(Yii::app()->user->getState("identity")->user_role=="user"){
            $user_tasks = unserialize(Yii::app()->user->getState("identity")->user_tasks);
            foreach($user_tasks as $user_task_id){
                if(is_string($task_id)){
                    if($user_task_id == $task_id){
                        return true;
                    }
                } else if(is_array($task_id)){
                    if(in_array($user_task_id, $task_id)){
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }
    public function permissionGate($task_id){
        if(!$this->checkPermissions($task_id)){
            if(Yii::app()->request->isAjaxRequest){
                AjaxOutput::i()->setAuthorization(false)->display();
            } else {
                throw new CHttpException(403,"You are not authorized to access this page");                
            }
        }
    }
}