<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class UserIdentity extends CUserIdentity {

    
    private $_id;
    /**
     * Authenticates a user.
     * The example implementation makes sure if the username and password
     * are both 'demo'.
     * In practical applications, this should be changed to authenticate
     * against some persistent user identity storage (e.g. database).
     * @return boolean whether authentication succeeds.
     */
    public function authenticate() {
        $model = User::model()->authenticate($this->username, $this->password);       
        if($model !== false){            
            $this->_id = $model->user_id;
            $this->setState('identity', $model);   
            $this->errorCode = self::ERROR_NONE;
        } else {
            $this->errorCode = self::ERROR_PASSWORD_INVALID;
        }
          
        return !$this->errorCode;         
    }
    /**
     * Returns the ID of current user
     * @return integer
     */
    public function getId() {
        return $this->_id;
    }
    
}