<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file

*/
abstract class AbstractAdminSettingsForm extends CFormModel {
    /**
     * @var CWidget 
     */
    public $form;

    /**
     * Displays the settings form     * 
     * @param string $action url to which form will get postback
     */
    public function displayForm($action = "",$saveButtonText="Save Settings") {
        
        $data = Settings::i()->getByClass(get_called_class());
       
        if (!is_null($data)) {
            
            $this->attributes = $data;
             
        }
        $this->onBeforeDisplayingForm(new CEvent($this));
        $this->form = Yii::app()->controller->beginWidget('CActiveForm', array(
            'id' => 'formSettings_' . get_called_class(),
            'htmlOptions' => array('class' => 'dialog-form', 'enctype'=>"multipart/form-data", "style" => "padding:10px;"),
            'action' => $action,
            'enableClientValidation' => true,
            'errorMessageCssClass' => "error",
            'clientOptions' => array(
                'validateOnSubmit' => true,
                'validateOnChange' => false,
                'afterValidate' => 'js:submitFormViaAjax_' . get_called_class()
            )
        ));

        $this->adminForm();

        echo "<div>";
        echo Chtml::submitButton($saveButtonText, array("class" => "btn btn-primary", "id" => "btnSubmitForm_" . get_called_class(), "name" => "btnSubmitForm"));
        echo "</div>";
        $this->onAfterDisplayingForm(new CEvent($this));
        ?>

        <script type="text/javascript">
            
            
            // First create the event
            var formAjaxResponse = new CustomEvent("formAjaxResponse", {
                    detail: {
                            data: "davidwalsh"
                    }
            });
             
            function submitFormViaAjax_<?php echo get_called_class() ?>(form, data, hasError) {
                if (!hasError) {
                    form.ajaxSubmit({
                        type: "post",
                        dataType: "json",
                        success: function(data, textStatus, XMLHttpRequest) {
                            if (serverValidation(data) == true) {
                                if (data.status == true) {        
                                   
                                    $(".settings-alert").remove();
                                    $("<?php echo '#formSettings_' . get_called_class() ?>").prepend('<div class="alert alert-success settings-alert">Settings Saved!<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button></div>');
                                    
    var thisform = document.getElementById("formSettings_<?php echo get_called_class() ?>");
                                            formAjaxResponse.detail.data = data.data.result;                                            
                                            thisform.dispatchEvent(formAjaxResponse);
    $("<?php echo '#formSettings_' . get_called_class() ?>").animate({
                                        "background-color": "#FFEE9F",
                                    }, 1000, function() {
                                        $("<?php echo '#formSettings_' . get_called_class() ?>").animate({
                                            "background-color": "#FFFFFF",
                                        }, 1000, function() {
                                            
                                        });
                                    });
                                }
                            }
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            showError(textStatus, errorThrown);
                        }
                    });
                }

                return false;
            }

        </script>

        <?php
        Yii::app()->controller->endWidget();
    }
    
    /**
     * List the properties which you don't want to save in database for example, file upload
     * @return array
     */
    public function getExcludedProperties(){
        return array();
    }
    
    /**
     * Displays Settings form in admin area.
     */
    abstract public function adminForm();

    /**
     * Saves the form
     * @return boolean always returns true
     */
    public function saveForm() {
        $class_vars = get_class_vars(get_called_class());        
        $this->onBeforeSavingForm(new CEvent($this));
        foreach ($class_vars as $k => $v) {
            if ($k != "form" && $k !="title" && $k!="tabid") {       
                if(array_search($k, $this->getExcludedProperties())===false){
                    Settings::i()->save($k, $this->$k,get_called_class());                
                }    
            }
        }        
        $this->onAfterSavingForm(new CEvent($this));
        return true;
    }
    /**
     * 
     * @param type $event
     * @param type $eventRuns before saving the settingsform
     */
    public function onBeforeSavingForm($event){
        $this->raiseEvent('onBeforeSavingForm', $event);
    }
    
    /**
     * Runs before displaying the settings form
     */
    public function onBeforeDisplayingForm($event){
        $this->raiseEvent('onBeforeDisplayingForm', $event);
    }
    
    /**
     * Runs after saving the settings form
     */
    public function onAfterSavingForm($event){
        $this->raiseEvent('onAfterSavingForm', $event);
    }
    
    /**
     * Runs after displaying the settings form
     */
    public function onAfterDisplayingForm($event){
        $this->raiseEvent('onAfterDisplayingForm', $event);
    }
     
    /**
     * @staticvar null $instance
     * @return \static instanse of class
     */
    public static function i(){
        static $instance = null;
        if (null === $instance) {            
            $instance = new static();
            $data = Settings::i()->getByClass(get_called_class());
            if (!is_null($data)) {
                $instance->attributes = $data;
            }
        }        
        return $instance;
    }
    /**
     * This method reloads the properties of class from database
     * @return \AbstractAdminSettingsForm 
     */
    public function refresh(){  
        Settings::i()->init();
        $data = Settings::i()->getByClass(get_called_class());
        if (!is_null($data)) {
            $this->attributes = $data;
        }         
        return $this;
    }
}
