<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
abstract class AbstractModuleLoader{
    /**
     * This method will execute first
     */
    public static function init() {
        
    }
    /**
     * @return array configuration data
     */
    public static function getConfig(){
        return array();
    }    
    /**
     * @return array list of aliases 
     */
    public static function getImports(){
        return array();
    }
    /**
     * "mode" can be either "append" or "prepend".
     * "rules" will be list of url rewrite rules
     * @return array array("rules"=>array(),"mode"=>"prepend");
     */
    public static function getUrlRewritingRules(){
        return array("rules"=>array(),"mode"=>"prepend");
    }
    
    /**
     * @return array format should be like array("module/controller/action"=>"Human Readable Name");    
     */
    public static function getHomePages(){
        return array();
    }
}
