<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
 
abstract class AbstractWidget extends CFormModel {

    /** @var string */
    public $title;
    
    /** @var string */
    public $type;
    
    /** @var integer */
    public $id;
    
    /** @var string */
    public $panel;
    
    /** @var CWidget */
    public $form;
    
    /**
     * @return array Validation rules
     */
    public function rules() {       
        
        return array(
            array("panel, type", "required"),
            array("title", "length", "max" => 255, "allowEmpty" => true),
            array("id", "length", "allowEmpty" => true),
        );
    }
    /**
     * @return array Attribute labels
     */
    public function attributeLabels() {
        return array(
            "title" => "Title",
            "type" => "Type",
            "id" => "Id",
            "panel" => "Panel"
        );
    }

    
    /**
     * Displays the widget form in admin panel
     * 
     * @param Widget $model Database model of widget
     * @param type $action Url to which form will get posted
     */
    public function displayForm(Widget $model = null, $action = "") {
        $this->type = get_called_class();        
        if (!is_null($model)) {
            $data = unserialize($model->wd_data);
            foreach ($data as $key => $value) {
                $this->$key = $value;
            }
            $this->title = $model->wd_title;
            $this->id = $model->wd_id;
            $this->type = $model->wd_type;
            $this->panel = $model->wd_panel;
        }
        $this->form = Yii::app()->controller->beginWidget('CActiveForm', array(
            'id' => 'formWidget',
            'htmlOptions' => array('class' => 'dialog-form'),
            'action' => $action,
            'errorMessageCssClass' => "error",
        ));
        echo "<div class='form-group'>";
        echo $this->form->label($this, "title");
        echo $this->form->textField($this, "title",array("class"=>"form-control"));
        echo $this->form->error($this, "title");
        echo "</div>";
        
        $this->adminForm();
        
        
        echo $this->form->hiddenField($this, "id");
        echo $this->form->hiddenField($this, "type");
        echo $this->form->hiddenField($this, "panel");
  
        
        echo "<div>";
        echo Chtml::submitButton("Save", array("class" => "btn btn-primary", "id" => "btnSubmitWidgetForm", "name" => "btnSubmitWidgetForm"));
        echo "</div>";
        Yii::app()->controller->endWidget();
    }
    /**
     * Saves the widget form in admin panel
     * @return boolean Always returns true
     */
    public function saveForm() {
        $model = new Widget();
        if ($this->id > 0) {
            $model = Widget::model()->findByPk($this->id);
        }

        $class_vars = get_class_vars($this->type);
        $data = array();
        foreach ($class_vars as $k => $v) {
            $data[$k] = $this->$k;
        }
        $model->wd_data = serialize($data);

        if ($this->id == 0 || is_null($this->id) || $this->id == "") {
            //on insert
            $model->wd_order = Widget::model()->getMaxOrderIndex($this->panel) + 1;
        }
        $model->wd_panel = $this->panel;
        $model->wd_title = $this->title;
        $model->wd_type = $this->type;

        if ($model->validate()) {
            $model->save();
            return true;
        }

        return $model->getErrors();
    }
    /**
     * Deletes the widget.
     * @param Widget $model Model  of widget
     */
    public static function delete(Widget $model) {
        //update all records order by -1 who have order greator than 
        $sql = "UPDATE widgets SET wd_order = wd_order-1 WHERE wd_order > :wd_order AND wd_panel = :wd_panel";
        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->execute(array(":wd_order" => $model->wd_order, ":wd_panel" => $model->wd_panel));

        //delete itself
        $model->delete();
    }
    
    /**
     * Abstract method to write code for widget form in admin panel
     */
    public abstract function adminForm();

    /**
     * Abstract method to write code for widget which will get displayed in public area
     */
    public abstract function render($arg, $data);
}