<?php
/* 
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.


return array(
    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => 'Abhinav Software - Epaper CMS',
    'defaultController' => 'main',
    // preloading 'log' component
    'preload' => array('log'),
    'onBeginRequest' => array('ModuleLoader', 'loadModules'),
    // other controllers
    // autoloading model and component classes
    
    'import' => array(
        'ext.wideimage.*',
        'ext.yii-mailer.*',        
        'application.models.*',
        'application.models.forms.*',
        'application.components.*',
        'application.components.abstracts.*',
        'application.components.interfaces.*',
        'zii.widgets.*',   
        'ext.iealert.IEAlertWidget',
        'application.nplugins.settings.*',
        'application.nplugins.menuitems.*',
        'application.nplugins.widgets.*',
        
    ),
    'modules' => array(
        // uncomment the following to enable the Gii tool
        'epaper', 'page', 'slideshow','media',
        'gii' => array(
            'class' => 'system.gii.GiiModule',
            'password' => 'pass',
            // If removed, Gii defaults to localhost only. Edit carefully to taste.
            'ipFilters' => array('127.0.0.1', '10.0.0.*'),
        ),
    ),
    // application components
    'components' => array(
        'user' => array(
            // enable cookie-based authentication
            'allowAutoLogin' => true,
        ),
        'mobileDetect' => array(
			'class' => 'ext.mobiledetect.MobileDetect'
		),
        'cache' => array(
            'class' => 'system.caching.CFileCache',
        ),
        'coreMessages' => array('basePath' => 'protected/messages'),
         
        // uncomment the following to enable URLs in path-format
        'urlManager' => array(
            'urlFormat' => 'path',
            'showScriptName' => false,
            'rules' => array(
                'admin' => 'admin/default/index',
                
                // 'admin/<module>/<controller:\w+>/<id:\d+>' => '<module>/admin/<controller>/view',
                "imageprocessor" => 'image/index',
                
                'contact/' => 'main/contact',
                'signin/' => 'main/signin',
                'rss/' => 'main/rss',                 
                'signout/' => 'main/signout',
                'reset-password/' => 'main/passwordreset',
                'error/' => 'main/error',
               
                '<module>/' => '<module>/default/index',
                'admin/<module>/' => '<module>/admin/default/index',
                'admin/<module>/<controller:\w+>/<action:\w+>' => '<module>/admin/<controller>/<action>',
                
            /*
              '<controller:\w+>/<id:\d+>' => '<controller>/view',
              '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
              '<controller:\w+>/<action:\w+>' => '<controller>/<action>', */
            ),
        ), 
        'db' => array(
            'connectionString' => 'sqlite:' . dirname(__FILE__) . '/../data/testdrive.db',
        ),
        // uncomment the following to use a MySQL database
        'db' => require(__DIR__ . '/db.php'),
        'errorHandler' => array(
            // use 'site/error' action to display errors
            'errorAction' => 'main/error',
        ),
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'error, warning',
                ),
            // uncomment the following to show log messages on web pages
            /*
              array(
              'class'=>'CWebLogRoute',
              ),
             */
            ),
        ),
    ),
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => array(
        // this is used in contact page
        "uploadDir" => "/uploads/",
        "sitemapDir" => "/sitemaps/",
    ),
);




