<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class MainController extends PublicController {
 
    public function filters()
    {
        return array(            
            array(
                'COutputCache + index, rss, sitemap',
                'duration'=>  BasicSettings::i()->cache_duration,
                'varyByParam'=>array("id","alias"),
            ),
        );
    }
     
 
    
    public function actionIndex(){
        HeadComponent::i()->addTitle(BasicSettings::i()->site_hometitle);     
        if(trim(BasicSettings::i()->site_logo) != ""){ 
            HeadComponent::i()->setImage(Yii::app()->request->getBaseUrl(true)."/".BasicSettings::i()->site_logo);
        }
        $this->render("index");
    }
     
    public function actionRss(){          
        FeedComponent::i()->generate();
    }
     
 
    public function actionContact(){
       $this->breadcrumbs[Yii::t("core","Contact Us")] = $this->createUrl("main/contact");
        $formKey = new QACaptcha("contact");
        HeadComponent::i()->addTitle(Yii::t("core","Contact Us"))->addMetaDescription(Yii::t("core","Contact Us"))->addMetaKeywords(Yii::t("core","Contact").",".Yii::t("core","Contact Address").",".Yii::t("core","Contact Email").",".Yii::t("core","Contact Form"));   
        
        $form = new ContactForm();
        if (Yii::app()->request->isPostRequest) {
            $form->attributes = Yii::app()->request->getParam("ContactForm"); 
            if($formKey->validate()){
                if ($form->validate()) {
                    $send = $form->send();
                    if ($send===true) {                        
                        Yii::app()->user->setFlash('success', Yii::t("core",'<strong>Success!</strong> Your message has been sent successfully.'));                      
                    } else {
                        Yii::app()->user->setFlash('error',Yii::t("core",'<strong>Error!</strong> Error while sending message. Please contact:{admin_email}',array("admin_email"=>BasicSettings::i()->contact_email))."<br />".$send);                    
                    } 
                    $this->render("contact_result");
                    $formKey->clearKey();
                    exit();
                }
            } else {
                Yii::app()->user->setFlash('error', Yii::t("core",'<strong>Error!</strong> Invalid captcha.'))."  ".CHtml::link(Yii::t("core","Please Click Here and try again"),$this->createUrl("matrimonial/contact"));
                $this->render("contact_result");
                exit();
            }
        } 
        $this->render("contact", array("model" => $form,"formKey"=>$formKey));
    }
    
    public function actionSignin() {
        Yii::app()->theme = null;
        $this->layout = "/layouts/general_template";
        if (!Yii::app()->user->isGuest) {
            $this->redirect(Yii::app()->request->getBaseUrl());
        }
        $model = new LoginForm;
        
        HeadComponent::i()->addTitle(Yii::t("core","Sign In"))->addMetaDescription(Yii::t("core","Sign in to the admin control panel"));
        
        
        if (Yii::app()->request->isPostRequest) {
            
            $model->attributes = Yii::app()->request->getParam('LoginForm');
            // validate user input and redirect to the previous page if valid
             
            if ($model->validate() && $model->login()) {
                
                $this->redirect(Yii::app()->user->returnUrl);
            }
            
        }
           $this->render('signin', array('model' => $model));
    }

    public function actionSignout() {
        Yii::app()->user->logout();
        $this->redirect(Yii::app()->homeUrl);
    }

    public function actionPasswordreset() {
        Yii::app()->theme = null;
        $this->layout = "/layouts/general_template";
        $formKey = new QACaptcha("password_reset");

        if (!Yii::app()->user->isGuest) {
            $this->redirect($this->createUrl("main/changepassword"));
        }
        if (Yii::app()->request->isPostRequest) {
            if ($formKey->validate()) {
                $email = Yii::app()->request->getParam("email");
                 
                
                $model = User::model()->find("user_email = :email",[":email"=>$email]);
                if (!is_null($model)) {
                    $newpassword = substr(md5(time()), 0, 5);
                    $model->user_password = md5($newpassword);
                    $model->save();
                    // Sending Email
                    $sitename = BasicSettings::i()->site_title;
                    $url = $this->createAbsoluteUrl("main/signin");
                    $msg = Yii::t("core", "You have requested a password reset. <br /> Here is your new password:                
{new_password}                <br /><br /><br />

You may now login from the following url using above password.<br />
{url}
                            </br /><br />
If the above url is not clickable, please copy and paste it on your browser's address bar.                <br /><br />

Thank You! <br />
{site_title}", array("{new_password}" => $newpassword, "{url}" => $url, "{site_title}" => $sitename));

                    $message = new YiiMailer();
                    $message->isHTML(false);
                    $message->setSmtp(
                            EmailSettings::i()->smtp_host, EmailSettings::i()->smtp_port, EmailSettings::i()->smtp_secure, EmailSettings::i()->smtp_require_auth, EmailSettings::i()->smtp_username, EmailSettings::i()->smtp_password);
                    $message->Body = $msg;
                    $message->From = Settings::i()->get("admin_email");
                    $message->FromName = Settings::i()->get("admin_username");
                    $message->Subject = Yii::t("core", "Reset Password");
                    $message->addAddress(Settings::i()->get("admin_email"));

                    if ($message->send()) {
                        Yii::app()->user->setFlash('success', Yii::t("core", '<strong>Success!</strong> We have sent you a password reset email. Please check your email inbox.'));
                    } else {
                        Yii::app()->user->setFlash('error', Yii::t("core", '<strong>Error!</strong> Failed to send password reset email.'));
                    }
                } else {
                    Yii::app()->user->setFlash('error', Yii::t("core",'<strong>Error!</strong> Email does not exists.'));
                } 
            } else {
                Yii::app()->user->setFlash('error', Yii::t("core",'<strong>Error!</strong> Invalid answer to security question'));
            }
        }

        HeadComponent::i()->addTitle(Yii::t("core","Password Reset"));
         
        $this->render("passwordreset", array("formKey" => $formKey));
    }

    
    
    public function actionError() {
         
        
        
       $this->pageTitle = "Error";
                
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo $error['message'];
            } else {
                HeadComponent::i()->addTitle(Yii::t("core","Error"));
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive", "robots");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive, nosnippet, noodp, noimageindex, notranslate", "googlebot");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive, nosnippet, noodp, noydir", "slurp");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive, nosnippet, noodp", "msnbot");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive", "teoma");                
                $this->render('error', $error);
            }
        }
    }

}
