<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class DefaultController extends AdminController {

    public function actionIndex() {
        
        
        $this->pageTitle = "Welcome to dashboard";
        if(License::i()->license == License::DEVELOPER){
            $this->render('developer_index');
        } else {
            $this->render('index');
        }        
    }
    public function actionPhpinfo(){
        $this->renderPartial("phpinfo");
    }
    public function actionError(){
        $this->pageTitle = "Error";
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo $error['message'];
            } else {
                HeadComponent::i()->addTitle(Yii::t("core","Error"));
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive", "robots");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive, nosnippet, noodp, noimageindex, notranslate", "googlebot");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive, nosnippet, noodp, noydir", "slurp");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive, nosnippet, noodp", "msnbot");
                Yii::app()->getClientScript()->registerMetaTag("noindex, nofollow, noarchive", "teoma");                
                $this->render('//admin/default/error', $error);
            }
        }
    }
    public function actionGeneratesitemap(){
        SitemapGenerator::make();
    }
    public function actionCompanyfeed(){
        Yii::import("ext.simplepie.*");
        $cache_location = Yii::getPathOfAlias("application.runtime.simplepie_cache");
        if(!file_exists($cache_location)){
            mkdir($cache_location);
        }
        $feed = new SimplePie();
         
        $feed->set_feed_url("http://feeds.feedburner.com/abhinavsoftware");
        $feed->set_cache_location($cache_location);
        $feed->init();
        $feed->handle_content_type();
     
        $this->renderPartial("companyfeed",array("items"=>$feed->get_items(0,4)));
    }
    
    public function actionAbout(){
        TaskComponent::i()->permissionGate("sys_view_about");
        if(License::i()->license==License::PERSONAL){
            $this->pageTitle = "About";
            $this->render("about");
        }
    }
    public function actionChangepassword() {
        $model = new ChangePasswordForm();
        if (Yii::app()->request->isPostRequest) {
            $user_id = Yii::app()->user->id;
            $model->attributes = Yii::app()->request->getParam("ChangePasswordForm");
            $model->user_id = $user_id;
            if ($model->validate()) {                
                $admin_password = Settings::i()->save("admin_password", $model->old_user_password);
                $model = new ChangePasswordForm();
                Yii::app()->user->setFlash("success", "Password has been changed successfully");
            }
        }
        $this->pageTitle = "Change Password";
        $this->render("changepassword", array(
            "model" => $model
        ));
    }

    public function actionSettings() {
        TaskComponent::i()->permissionGate("sys_change_settings");
        $tab_id = Yii::app()->request->getParam("tab_id", "home");
        $this->pageTitle = "Settings";
        
        //Generate Setting Forms
        $np = NPlugins::i()->get();
        $setting_tabs = $np["setting_tabs"];
         
        foreach($setting_tabs as $tab){
            AdminSettings::i()->addTab($tab["id"],$tab["title"]);
            foreach($tab["forms"] as $form_class=>$form_title){
                AdminSettings::i()->addForm($tab["id"],  strtolower($form_class),$form_title,$form_class);
            }
        }
         
        
        $forms = AdminSettings::i()->getFormsByTabId($tab_id);
        
        $myforms = array();
        foreach ($forms as $form) {
            $objForm = new $form["class"];
            if ($_SERVER["REQUEST_METHOD"] == "POST") {
                if (isset($_POST[$form["class"]])) {                    
                    $objForm->attributes = Yii::app()->request->getParam($form["class"]);
                    if ($objForm->validate()) {
                        $objForm->saveForm();   
                         
                        AjaxOutput::i()->setStatus(true)->setData($form["class"]::i()->refresh()->attributes);
                        
                    } else {
                        AjaxOutput::i()->setStatus(false)->setValidationStatus(false)->setValidationErrors($objForm->getErrors());
                    }
                }
            }
            $myforms[] = array("formObject"=>$objForm,"formTitle"=>$form["title"]);
        }
        
       
        
        if(Yii::app()->request->isPostRequest){            
            AjaxOutput::i()->display();
        } else {            
            $this->render("settings", array("myforms" => $myforms,"tabs"=>AdminSettings::i()->getTabs()));
        }
    }

     

    public function actionAccount() {
        $this->pageTitle = "Change Password";
       
        $cpForm = new ChangePasswordForm();
 


        if (isset($_POST["ChangePasswordForm"])) {
            $params = Yii::app()->request->getParam("ChangePasswordForm");

            $cpForm->attributes = $params;
            if ($cpForm->validate()) {
                $cpForm->save();
                $cpForm = new ChangePasswordForm();
                Yii::app()->user->setFlash('success', 'Password Changed Successfully');
            }
        }


        $this->render("account", array("cpForm" => $cpForm));
    }

}
