<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class MenuController extends AdminController {
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("sys_manage_menus");
    }
    public function actionIndex() {
        $model = new Menu();
        $menulist = CHtml::listData(Menu::model()->findAll(), "m_id", "m_name");
        $menulist[0] = "[None]";
        $this->pageTitle = "Menu";
        $this->render("index", array("model" => $model, "menulist" => $menulist));
    }

    public function actionLoadlist() {
        $page = Yii::app()->request->getParam("page", 1);
        $limit = $this->perpage;
        $offset = ($page * $limit) - $limit;

        $data = Menu::model()->listIt($limit, $offset);

        if (count($data["records"]) > 0) {
            AjaxOutput::i()->setStatus(true);
        }
        AjaxOutput::i()->setData($data);
        AjaxOutput::i()->display();
    }

    public function actionListall() {
        $data = Menu::model()->listit(10000000, 0);
        if (count($data["records"]) > 0) {
            AjaxOutput::i()->setStatus(true);
        }
        AjaxOutput::i()->setData($data);
        AjaxOutput::i()->display();
    }
    
    public function actionRefresh(){
        MenuComponent::i()->updateMenuCache();
        AjaxOutput::i()->display();
    }

    public function actionSave() {
        $params = Yii::app()->request->getParam("Menu");
        $id = $params["m_id"];

        $model = new Menu();
        if ($id > 0) {
            $model = Menu::model()->findByPk($id);
        }
        $model->attributes = $params;
        if ($model->validate()) {
            AjaxOutput::i()->setValidationStatus(true);
            if ($model->save()) {
                
                AjaxOutput::i()->setStatus(true);
            }
        } else {
            AjaxOutput::i()->setValidationStatus(false);
            AjaxOutput::i()->setValidationErrors($model->getErrors());
        }
        MenuComponent::i()->updateMenuCache();
        AjaxOutput::i()->display();
    }

    public function actionGet() {
        $id = Yii::app()->request->getParam("id");
        $model = Menu::model()->findByPk($id);
        if (!is_null($model)) {
            AjaxOutput::i()->setStatus(true);
            AjaxOutput::i()->setData($model);
        }
        AjaxOutput::i()->display();
    }

    public function actionDelete() {
        $id = Yii::app()->request->getParam("id");
        $model = Menu::model()->findByPk($id);
        if (!is_null($model)) {
            $model->delete();
            AjaxOutput::i()->setStatus(true);
        }
        
        AjaxOutput::i()->display();
    }

    public function actionSave_assignments() {
        $formAssign = Yii::app()->request->getParam("formAssign");
        foreach ($formAssign as $placeholder => $value) {
            $models = Menu::model()->findAll("m_place = :m_place", array(":m_place" => $placeholder));
            if (count($models) > 0) {
                foreach ($models as $model) {
                    $model->m_place = "";
                    $model->save();
                }
            }
            $model = Menu::model()->findByPk($value);
            if (!is_null($model)) {
                $model->m_place = $placeholder;
                $model->save();
            }
        }
        MenuComponent::i()->updateMenuCache();
        AjaxOutput::i()->setStatus(true);
        AjaxOutput::i()->display();
    }
 
    public function actionGet_assignments() {
        
        $placeholders = NPlugins::i()->menu_placeholders;
        $result = array();
        foreach ($placeholders as $ph) {
            $models = Menu::model()->findAll("m_place = :m_place", array(":m_place" => $ph["id"]));                        
            if (count($models) > 0) {
                foreach ($models as $model) {
                    $result[] = array("value" => $model->m_id, "placeholder" => $model->m_place);                   
                }
            }
        }
        AjaxOutput::i()->setData($result);
        AjaxOutput::i()->display();
    }

    public function actionMenuitem_index() {
        $m_id = Yii::app()->request->getParam("m_id");
        $model = Menu::model()->findByPk($m_id);
        if (is_null($model)) {
            throw new CHttpException("404", "Menu not found");
        }
        $this->pageTitle = "Menu Manager - " . $model->m_name;
        
         
        $data["class_list"] = array();
        $menuitems = NPlugins::i()->menuitems;
        foreach($menuitems as $m){
            $data["class_list"][$m["class"]] = $m["title"];
        }
        $data["m_id"] = $m_id;
        $this->render("menuitem_index", $data);
    }

    public function actionMenuitem_loadlist() {        
        $rec = function($pid,$menu_id) use(&$rec){
            
            $cri = new CDbCriteria();
            $cri->condition = "mitem_pid = :mitem_pid AND m_id = :m_id";
            $cri->params = array(":mitem_pid" => $pid, ":m_id" => $menu_id);
            $cri->order = "mitem_order ASC";
            $models = Menuitem::model()->findAll($cri);
            $data = array();
            if (count($models) > 0) {
                foreach ($models as $model) {
                    $data[] = array(
                        "label"=>$model->mitem_title,
                        "nodeid"=>$model->mitem_id,                       
                        "children"=>$rec($model->mitem_id,$menu_id)
                    );
                }                
            }
            return $data;
        };
        
        $menu_id = Yii::app()->request->getParam("m_id", 0);
        $data = $rec(0,$menu_id);
       
        
        echo json_encode($data);
    }

    public function actionMenuitem_saveorder(){
        $tree = json_decode(Yii::app()->request->getParam("tree"));
        $menu_id = Yii::app()->request->getParam("m_id");
        
        $rec = function($menuitems,$pid) use (&$rec,$menu_id){
            $i = 1;
            foreach($menuitems as $menuitem){
                 
                Menuitem::model()->updateByPk($menuitem->nodeid,array("mitem_order"=>$i,"mitem_pid"=>$pid));
                $i++;
                if(isset($menuitem->children)){
                     
                    $rec($menuitem->children,$menuitem->nodeid);
                }
            }
        };
        
        $rec($tree,0);
        MenuComponent::i()->updateMenuCache();
        AjaxOutput::i()->display();
    }
    
    
    public function actionMenuitem_move() {
        $direction = Yii::app()->request->getParam("direction");
        $id = Yii::app()->request->getParam("id");
        Menuitem::model()->move($id, $direction);
        AjaxOutput::i()->setStatus(true);
        AjaxOutput::i()->display();
    }

    public function actionMenuitem_new() {
        $mode = Yii::app()->request->getParam("mode", "get");
        $classname = Yii::app()->request->getParam("classname");
        $menu_id = Yii::app()->request->getParam("menu_id");
        $model = null;
        $id = Yii::app()->request->getParam("id", 0);
        
        if ($id > 0) {
            $model = Menuitem::model()->findByPk($id);
            $classname = $model->mitem_type;
            $menu_id = $model->m_id;
        }
         
        $obj = new $classname();
        $obj->menu_id = $menu_id;

        if ($mode == "save") {
            $obj->attributes = Yii::app()->request->getParam($classname);
            if ($obj->validate()) {
                $obj->saveForm();
                MenuComponent::i()->updateMenuCache();
                echo "success";
                exit();
            }
        }

        $obj->displayForm($model, $this->createUrl("admin/menu/menuitem_new", array("classname" => $classname, "menu_id" => $menu_id)));
    }

    public function actionMenuitem_delete() {
        $id = Yii::app()->request->getParam("id", 0);
        if ($id > 0) {
            $model = Menuitem::model()->findByPk($id);
            if (!is_null($model)) {
                AbstractMenuitem::delete($model);
            }
			MenuComponent::i()->updateMenuCache();
            AjaxOutput::i()->setStatus(true)->display();
        }
    }

}