<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PanelController extends AdminController {
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("sys_manage_panels");
    }
    public function actionIndex() {
        $this->pageTitle = "Available Panels";
        $panellist = NPlugins::i()->widget_panels;
        $this->render("index", array("panellist" => $panellist));
    }

    public function actionWidget_index() {
        $this->pageTitle = "Widget Manager - " . Yii::app()->request->getParam("panel");
         
        
        $data["class_list"] = array();
        $menuitems = NPlugins::i()->widgets;
        foreach($menuitems as $m){
            $data["class_list"][$m["class"]] = $m["title"];
        }
        
        $data["panel"] = Yii::app()->request->getParam("panel");
        $this->render("widget_index", $data);
        
        
    }

    public function actionWidget_loadList() {
        $panel = Yii::app()->request->getParam("wd_panel", 0);
        $cri = new CDbCriteria();
        $cri->condition = "wd_panel = :wd_panel";
        $cri->params = array(":wd_panel" => $panel);
        $cri->order = "wd_order ASC";
        $models = Widget::model()->findAll($cri);
        $result = $this->renderPartial("widget_loadlist", array("models" => $models), true);
        AjaxOutput::i()->setData($result);
        AjaxOutput::i()->display();
    }
    
    public function actionWidget_saveorder(){
        $i = 1;
        foreach ($_POST['item'] as $wd_id) {
            Widget::model()->updateByPk($wd_id, array("wd_order"=>$i),"wd_panel = :wd_panel",array(":wd_panel"=>Yii::app()->request->getParam("wd_panel")));            
            $i++;
        }
    }

    public function actionWidget_move() {
        $direction = Yii::app()->request->getParam("direction");
        $id = Yii::app()->request->getParam("id");
        Widget::model()->move($id, $direction);
        AjaxOutput::i()->setStatus(true);
        AjaxOutput::i()->display();
    }

    public function actionWidget_new() {
        $classname = Yii::app()->request->getParam("classname");
        $panel = Yii::app()->request->getParam("panel");
        $model = null;
        $id = Yii::app()->request->getParam("id", 0);
        if ($id > 0) {
            $model = Widget::model()->findByPk($id);
            $classname = $model->wd_type;
        }
        $obj = new $classname();
        $obj->panel = $panel;
        if (isset($_POST[$classname])) {
            $obj->attributes = Yii::app()->request->getParam($classname);
            if ($obj->validate()) {
                $obj->saveForm();
                echo "success";
                exit();
            }
        }
        $obj->displayForm($model, $this->createUrl("admin/panel/widget_new", array("classname" => $classname, "panel" => $panel)));
    }

    public function actionWidget_delete() {
        $id = Yii::app()->request->getParam("id", 0);
        if ($id > 0) {
            $model = Widget::model()->findByPk($id);
            if (!is_null($model)) {
                AbstractWidget::delete($model);
            }
            AjaxOutput::i()->setStatus(true)->display();
        }
    }

}