<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class QacaptchaController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("sys_manage_captcha");
    }
    public function actionIndex(){
        $formModel = new QACaptchaQuestion();
        $this->pageTitle = "Q&A Captcha Manager";
        $this->render("index",array("formModel"=>$formModel));
    }
    public function actionLoadlist(){
        $page = Yii::app()->request->getParam("page",1);
        $limit = 10;
        $offset = ($page * $limit) - $limit;
        $data = QACaptchaQuestion::model()->listit($limit, $offset);
        AjaxOutput::i()->setData($data)->setStatus(true)->display();
    }
    public function actionGet(){
        $id = Yii::app()->request->getParam("id");
        $model = QACaptchaQuestion::model()->findByPk($id);
        if(!is_null($model)){
            AjaxOutput::i()->setData($model)->setStatus(true);
        }
        AjaxOutput::i()->display();
    }
    public function actionSave(){
        $params = Yii::app()->request->getParam("QACaptchaQuestion");
        $model = new QACaptchaQuestion();
        if($params["qa_id"]>0){
            $model = QACaptchaQuestion::model()->findByPk($params["qa_id"]);
            if(is_null($model)){
                AjaxOutput::i()->setError("Question not found")->display();
            }
        } 
        $model->attributes = $params;
        if($model->validate()){
            $model->save();
            AjaxOutput::i()->setStatus(true);
        }else{
            AjaxOutput::i()->setValidationStatus(false)
                    ->setValidationErrors($model->getErrors());
        }
        AjaxOutput::i()->display();
    }
    public function actionDelete(){
        $id = Yii::app()->request->getParam("id");
        $model = QACaptchaQuestion::model()->findByPk($id);
        if(!is_null($model)){
            $model->delete();
        }
        AjaxOutput::i()->setStatus(true)->display();
    }    
}