<?php

class UserController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("sys_manage_users");
    }
    public function actionIndex(){
        $model = new User();
        $this->pageTitle = "User Manager";
        $this->render("index",array('formModel'=>$model));
    }
    public function actionLoadlist(){
        $page = Yii::app()->request->getParam("page",1);
 
        $offset = ($page * $this->perpage) - $this->perpage;
        
        $cri=new CDbCriteria();
        $cri->limit = $this->perpage;
        $cri->offset = $offset;
        $cri->order = "user_id desc";
        $models = User::model()->findAll($cri);
        
        $total = User::model()->count();
        
        AjaxOutput::i()->setStatus(true)->setDataArray($models,$total)->display();
        
    }
    public function actionGet(){
        $id = Yii::app()->request->getParam("id");
        $model = User::model()->findByPk($id);
        if(!is_null($model)){
            AjaxOutput::i()->setData($model)->setStatus(true);
        }
        AjaxOutput::i()->display();
    }
    public function actionSave(){
        $params = Yii::app()->request->getParam("User");
        $model = new User();
         $model->scenario = "new";
        if($params["user_id"]>0){            
            $model = User::model()->findByPk($params["user_id"]);
            if(is_null($model)){
                AjaxOutput::i()->setError("User not found")->display();
            }    
            $model->scenario = "update";
        }
        if(trim($params["user_password"])==""){            
            unset($params["user_password"]);
        } else {
            $params["user_password"] = md5($params["user_password"]);
        }
        
        $model->attributes = $params; 
        $model->user_tasks = "";
        if($model->validate()){
            $model->save();
            AjaxOutput::i()->setStatus(true);
        }else{
            AjaxOutput::i()->setValidationStatus(false)
                    ->setValidationErrors($model->getErrors());
        }
        AjaxOutput::i()->display();
    }
    public function actionDelete(){         
        $id = Yii::app()->request->getParam("id");
        
        if($id==1){
            AjaxOutput::i()->setError("You can not delete the super user")->display();
        }
        
        if($id==Yii::app()->user->getId()){
            AjaxOutput::i()->setError("You can not delete yourself")->display();
        }
        
        $model = User::model()->findByPk($id);
        if(!is_null($model)){
            $model->delete();
            AjaxOutput::i()->setData($model)->setStatus(true);
        }
        AjaxOutput::i()->display();
    }
    public function actionTasks(){        
        $user_id = Yii::app()->request->getParam("user_id");
        $model = User::model()->findByPk($user_id);
        if(is_null($model)){
            throw new CHttpException(404,"User Not Found");
        }
            
        if(Yii::app()->request->isPostRequest){
            //save
            $tasks = array();
            foreach($_POST as $k=>$v){
                $tasks[] = $k;
            }
            $model->user_tasks = serialize($tasks);
            $model->save();
            Yii::app()->user->setFlash("success","Tasklist Saved!");
        } 
        
        $this->pageTitle = "Manage Tasks for User: ".$model->user_name;
        $this->render("tasks",array("tasks"=>TaskComponent::i()->listTasks(),"model"=>$model));         
    }
}