<?php
class IEAlertWidget extends CWidget{
    private $_assetsUrl;
    public function getAssetsUrl(){
        if(is_null($this->_assetsUrl)){
            $assetsPath = Yii::getPathOfAlias('ext.iealert.assets');               
            $this->_assetsUrl = Yii::app()->getAssetManager()->publish($assetsPath);
        }
        return $this->_assetsUrl;
    }
    
    public function init(){
        parent::init();
        $cs=Yii::app()->clientScript;
        $cs->registerCssFile($this->assetsUrl."/iealert/style.css");        
        $cs->registerScriptFile($this->assetsUrl."/iealert.min.js");
    }
    
    const IE6 = "ie6";
    const IE7 = "ie7";
    const IE8 = "ie8";
    const IE9 = "ie9";
   
    public $ielevel = self::IE6;
    
    public function run(){
        ?>
<script>
$("body").iealert({
  support: "<?php echo $this->ielevel; ?>",
  title:"<?php echo Yii::t("iealert","Did you know that your Internet Explorer is out of date?") ?>",
  text: "<?php echo Yii::t("iealert","To get the best possible experience using our site we recommend that you upgrade to a modern web browser. To download a newer web browser click on the Upgrade button."); ?>",
  upgradeTitle: "<?php echo Yii::t("iealert","Upgrade") ?>"
});    
</script>
<?php
    }
}