<?php
/*
  Application Developed By Abhinav Software
  Website: http://abhinavsoftware.com
  Email: contact@abhinavsoftware.com
  Developer: Ankur Gupta (ankurgupta555@gmail.com)
  Copyright Ankur Gupta

  For licensing and terms of use please read license.txt file
 */
/**
 * This is the model class for table "menus".
 *
 * The followings are the available columns in table 'menus':
 * @property integer $m_id
 * @property string $m_name
 * @property string $m_place
 */
class Menu extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Menu the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'menus';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('m_name', 'required'),
			array('m_name, m_place', 'length', 'max'=>255),
                        array('m_place', 'length',   'allowEmpty'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('m_id, m_name, m_place', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'm_id' => 'Menu Id',
			'm_name' => 'Menu Name',
			'm_place' => 'Placeholder',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('m_id',$this->m_id);
		$criteria->compare('m_name',$this->m_name,true);
		$criteria->compare('m_place',$this->m_place,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function listIt($limit, $offset){
            $mph = NPlugins::i()->menu_placeholders;            
            
            $cmd = Yii::app()->db->createCommand();
            $records = $cmd->select("*")->from($this->tableName())->order("m_id DESC")->limit($limit)->offset($offset)->queryAll();
            $d["records"] = $records;
            $n=0;
            foreach($records as $r){
                $human = "";
                $placeholder = NPlugins::i()->find("menu_placeholders","id",$r["m_place"]);  
                
                if($placeholder!=false){ $human = $placeholder["title"]; }
                $d["records"][$n]["m_place_human"] = $human;
                $n++;
            }
            
            $d["total"] = $cmd->select("COUNT(*)")->from($this->tableName())->queryScalar();
            return $d;
        }
        
        
        
}